/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.util;

import java.util.Calendar;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsConstants;

public class IncrementalUtils {
    public static long getIncrementalStartTime(long lastAccessTime, AnalyticsConstants.IncrementalWindowUnit windowUnit, int incBuffer) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(lastAccessTime);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        switch (windowUnit) {
            case YEAR: {
                cal.set(1, year - incBuffer);
                cal.set(2, 0);
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTimeInMillis();
            }
            case MONTH: {
                cal.set(1, year);
                cal.set(2, month - incBuffer);
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTimeInMillis();
            }
            case DAY: {
                cal.set(1, year);
                cal.set(2, month);
                cal.set(5, day - incBuffer);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTimeInMillis();
            }
            case HOUR: {
                cal.set(1, year);
                cal.set(2, month);
                cal.set(5, day);
                cal.set(11, hour - incBuffer);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTimeInMillis();
            }
            case MINUTE: {
                cal.set(1, year);
                cal.set(2, month);
                cal.set(5, day);
                cal.set(11, hour);
                cal.set(12, minute - incBuffer);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTimeInMillis();
            }
            case SECOND: {
                cal.set(1, year);
                cal.set(2, month);
                cal.set(5, day);
                cal.set(11, hour);
                cal.set(12, minute);
                cal.set(13, second - incBuffer);
                cal.set(14, 0);
                return cal.getTimeInMillis();
            }
        }
        return lastAccessTime + 1L;
    }
}

