/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.core.internal;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.SocketException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsDataService;
import org.wso2.carbon.analytics.spark.core.AnalyticsProcessorService;
import org.wso2.carbon.analytics.spark.core.CarbonAnalyticsProcessorService;
import org.wso2.carbon.analytics.spark.core.SparkContextServiceImpl;
import org.wso2.carbon.analytics.spark.core.SparkScriptCAppDeployer;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsUDFException;
import org.wso2.carbon.analytics.spark.core.interfaces.SparkContextService;
import org.wso2.carbon.analytics.spark.core.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.core.internal.SparkAnalyticsExecutor;
import org.wso2.carbon.analytics.spark.core.internal.jmx.AnalyticsScriptLastExecutionStartTime;
import org.wso2.carbon.analytics.spark.core.internal.jmx.IncrementalLastProcessedTimestamp;
import org.wso2.carbon.analytics.spark.core.udf.CarbonUDF;
import org.wso2.carbon.analytics.spark.utils.ComputeClasspath;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.utils.CarbonUtils;

public class AnalyticsComponent {
    private static final String PORT_OFFSET_SERVER_PROP = "Ports.Offset";
    private static final Log log = LogFactory.getLog(AnalyticsComponent.class);
    private static boolean initialized;

    protected void activate(ComponentContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activating Analytics Spark Core");
        }
        try {
            this.checkAnalyticsEnabled();
            this.checkAnalyticsStatsEnabled();
            BundleContext bundleContext = ctx.getBundleContext();
            if (ServiceHolder.isAnalyticsEngineEnabled()) {
                try {
                    int portOffset = CarbonUtils.getPortFromServerConfig((String)PORT_OFFSET_SERVER_PROP) + 1;
                    ServiceHolder.setAnalyticskExecutor(new SparkAnalyticsExecutor(this.getLocalHostname(), portOffset));
                    ServiceHolder.getAnalyticskExecutor().initializeSparkServer();
                }
                catch (Throwable e) {
                    String msg = "Error initializing analytics executor: " + e.getMessage();
                    log.error((Object)msg, e);
                }
            }
            CarbonAnalyticsProcessorService analyticsProcessorService = new CarbonAnalyticsProcessorService();
            bundleContext.registerService(AnalyticsProcessorService.class, (Object)analyticsProcessorService, null);
            ServiceHolder.setAnalyticsProcessorService(analyticsProcessorService);
            SparkScriptCAppDeployer sparkScriptCAppDeployer = new SparkScriptCAppDeployer();
            bundleContext.registerService(AppDeploymentHandler.class.getName(), (Object)sparkScriptCAppDeployer, null);
            SparkContextServiceImpl scs = new SparkContextServiceImpl();
            bundleContext.registerService(SparkContextService.class, (Object)scs, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Finished activating Analytics Spark Core");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error in registering the analytics processor service! ", (Throwable)ex);
        }
        try {
            String lastExecutionStartTime;
            ObjectName lastExecutionStartTimeMbean;
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            String lastProcessedTimestamp = "org.wso2.carbon:00=analytics,01=LAST_PROCESSED_TIMESTAMP";
            ObjectName lastProcessedTimestampMbean = new ObjectName(lastProcessedTimestamp);
            if (!platformMBeanServer.isRegistered(lastProcessedTimestampMbean)) {
                IncrementalLastProcessedTimestamp processedTimestampBean = new IncrementalLastProcessedTimestamp();
                platformMBeanServer.registerMBean(processedTimestampBean, lastProcessedTimestampMbean);
            }
            if (!platformMBeanServer.isRegistered(lastExecutionStartTimeMbean = new ObjectName(lastExecutionStartTime = "org.wso2.carbon:00=analytics,01=ANALYTICS_SCRIPT_LAST_EXECUTION_START_TIME"))) {
                AnalyticsScriptLastExecutionStartTime analyticsScriptLastExecutionStartTime = new AnalyticsScriptLastExecutionStartTime();
                platformMBeanServer.registerMBean(analyticsScriptLastExecutionStartTime, lastExecutionStartTimeMbean);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to create EventCounter stat MBean: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctx) {
        ServiceHolder.getAnalyticskExecutor().stop();
    }

    protected void setTaskService(TaskService taskService) {
        this.checkAnalyticsEnabled();
        ServiceHolder.setTaskService(taskService);
        if (ServiceHolder.isAnalyticsExecutionEnabled()) {
            try {
                ServiceHolder.getTaskService().registerTaskType("ANALYTICS_SPARK");
            }
            catch (TaskException e) {
                log.error((Object)"Error while registering the task type : ANALYTICS_SPARK", (Throwable)e);
            }
        }
    }

    protected void unsetTaskService(TaskService taskService) {
        ServiceHolder.setTaskService(null);
    }

    protected void setAnalyticsDataService(AnalyticsDataService analyticsDataService) {
        ServiceHolder.setAnalyticsDataService(analyticsDataService);
    }

    protected void unsetAnalyticsDataService(AnalyticsDataService analyticsDataService) {
        ServiceHolder.setAnalyticsDataService(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        ServiceHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ServiceHolder.setRegistryService(null);
    }

    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        ServiceHolder.setTenantRegistryLoader(tenantRegistryLoader);
    }

    protected void unsetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        ServiceHolder.setTenantRegistryLoader(null);
    }

    protected void addCarbonUDF(CarbonUDF carbonUDF) {
        try {
            if (ServiceHolder.getAnalyticskExecutor() != null) {
                ServiceHolder.getAnalyticskExecutor().registerUDFFromOSGIComponent(carbonUDF);
            } else {
                ServiceHolder.addCarbonUDFs(carbonUDF);
            }
            this.addCarbonUDFJarToSparkClasspath(carbonUDF.getClass());
        }
        catch (AnalyticsUDFException e) {
            log.error((Object)("Error while registering UDFs from OSGI components: " + e.getMessage()), (Throwable)((Object)e));
        }
    }

    private void addCarbonUDFJarToSparkClasspath(Class carbonUDFClass) {
        String[] jarPath = carbonUDFClass.getProtectionDomain().getCodeSource().getLocation().getPath().split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        String jarName = jarPath[jarPath.length - 1].split("_")[0];
        ComputeClasspath.addAdditionalJarToClasspath((String)jarName);
    }

    protected void removeCarbonUDFs(CarbonUDF carbonUDF) {
        ServiceHolder.removeCarbonUDFs();
    }

    private void checkAnalyticsEnabled() {
        if (!initialized) {
            initialized = true;
            if (ServiceHolder.isAnalyticsEngineEnabled() && System.getProperty("disableAnalyticsEngine") != null && Boolean.parseBoolean(System.getProperty("disableAnalyticsEngine"))) {
                ServiceHolder.setAnalyticsEngineEnabled(false);
                ServiceHolder.setAnalyticsExecutionEnabled(false);
                ServiceHolder.setAnalyticsSparkContextEnabled(false);
            }
            if (ServiceHolder.isAnalyticsExecutionEnabled() && System.getProperty("disableAnalyticsExecution") != null && Boolean.parseBoolean(System.getProperty("disableAnalyticsExecution"))) {
                ServiceHolder.setAnalyticsExecutionEnabled(false);
            }
            if (ServiceHolder.isAnalyticsSparkContextEnabled() && System.getProperty("disableAnalyticsSparkCtx") != null && Boolean.parseBoolean(System.getProperty("disableAnalyticsSparkCtx"))) {
                ServiceHolder.setAnalyticsSparkContextEnabled(false);
            }
        }
    }

    private void checkAnalyticsStatsEnabled() {
        if (initialized && !ServiceHolder.isAnalyticsStatsEnabled() && System.getProperty("enableAnalyticsStats") != null && Boolean.parseBoolean(System.getProperty("enableAnalyticsStats"))) {
            ServiceHolder.setAnalyticsStatsEnabled(true);
        }
    }

    private String getLocalHostname() throws SocketException {
        String localIP = System.getenv("SPARK_LOCAL_IP");
        if (localIP != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Spark host is set from the SPARK_LOCAL_IP property : " + localIP));
            }
            return localIP;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Spark host is set NOT set, hence using the node network interface");
        }
        return Utils.getIpAddress();
    }
}

