/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.tokenizer;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.StreamProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.util.ArrayList;
import java.util.List;

@Extension(name="tokenize", namespace="entity", description="This splits a string into words", parameters={@Parameter(name="entity.element", description="The input entity element which should be split.", type={DataType.STRING})}, examples={@Example(syntax="define stream inputStream (hashtags string);\n@info(name = 'query1')\nfrom inputStream#entity:tokenize(hashtags)\nselect hashtag\ninsert into outputStream;", description="This query performs tokenization for the given entity element.")})
public class EntityTokenizer
extends StreamProcessor<State> {
    private List<Attribute> attributeList = new ArrayList<Attribute>();

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater, State state) {
        while (streamEventChunk.hasNext()) {
            String[] words;
            StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
            String event = (String)this.attributeExpressionExecutors[0].execute((ComplexEvent)streamEvent);
            if (event.equals("null")) continue;
            for (String word : words = event.split(",")) {
                Object[] data = new Object[]{word};
                complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, data);
                nextProcessor.process(streamEventChunk);
            }
        }
    }

    protected StateFactory<State> init(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 1) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppCreationException("Entity element should be of type string. But found " + attributeExpressionExecutors[0].getReturnType());
            }
        } else {
            throw new IllegalArgumentException("Invalid no of arguments passed to text:tokenize() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("token", Attribute.Type.STRING));
        this.attributeList = attributes;
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public List<Attribute> getReturnAttributes() {
        return this.attributeList;
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.SLIDE;
    }
}

