/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.tokenizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="tokenize", namespace="entity", description="This splits a string into words", parameters={@Parameter(name="entity.element", description="The input entity element which should be split.", type={DataType.STRING})}, examples={@Example(syntax="define stream inputStream (hashtags string);\n@info(name = 'query1')\nfrom inputStream#entity:tokenize(hashtags)\nselect hashtag\ninsert into outputStream;", description="This query performs tokenization for the given entity element.")})
public class EntityTokenizer
extends StreamProcessor {
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        while (streamEventChunk.hasNext()) {
            String[] words;
            StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
            String event = (String)this.attributeExpressionExecutors[0].execute((ComplexEvent)streamEvent);
            if (event.equals("null")) continue;
            for (String word : words = event.split(",")) {
                Object[] data = new Object[]{word};
                complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, data);
                nextProcessor.process(streamEventChunk);
            }
        }
    }

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length == 1) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppCreationException("Entity element should be of type string. But found " + attributeExpressionExecutors[0].getReturnType());
            }
        } else {
            throw new IllegalArgumentException("Invalid no of arguments passed to text:tokenize() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("token", Attribute.Type.STRING));
        return attributes;
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

