/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.wso2.appfactory;

import hudson.Extension;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkins.wso2.appfactory.CarbonSecurityRealm;
import org.jenkins.wso2.appfactory.CarbonUserDetails;
import org.jfree.util.Log;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.common.util.AppFactoryUtil;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(CarbonSecurityRealm.class.getName());
    public static final String JENKINS_SERVER_ADMIN_USERNAME = "JenkinsServerAdminUsername";
    public static final String JENKINS_SERVER_ADMIN_PASSWORD = "JenkinsServerAdminPassword";

    @DataBoundConstructor
    public CarbonSecurityRealm() {
    }

    @Extension
    public static DescriptorImpl install() {
        return new DescriptorImpl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("login request received for : " + username);
        }
        UserDetails userDetails = null;
        if (this.isJenkinsSystemUser(username)) {
            if (!this.authenticateJenkinsSystemUser(password)) throw new BadCredentialsException("Invalid credentials supplied app factory system user, check app factory configurations.");
            return this.createUserDetails(username, password);
        }
        String actualUsername = MultitenantUtils.getTenantAwareUsername((String)username);
        CarbonContext context = CarbonContext.getThreadLocalCarbonContext();
        try {
            UserStoreManager userStoreManager = context.getUserRealm().getUserStoreManager();
            if (userStoreManager == null) throw new BadCredentialsException("Invalid credentials supplied user name - " + username + "Password : *****");
            if (!userStoreManager.authenticate(actualUsername, (Object)password)) throw new BadCredentialsException("Invalid credentials supplied user name - " + username + "Password : *****");
            return this.createUserDetails(actualUsername, password);
        }
        catch (UserStoreException e) {
            throw new AuthenticationServiceException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected UserDetails createUserDetails(String username, String password) {
        GrantedAuthority[] authorities = new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY};
        return new CarbonUserDetails(username, password, authorities);
    }

    protected boolean isJenkinsSystemUser(String userName) {
        String adminUsername = "";
        try {
            adminUsername = AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty(JENKINS_SERVER_ADMIN_USERNAME);
        }
        catch (AppFactoryException e) {
            Log.error((Object)"Error reading jenkins admin username from configuration");
        }
        return adminUsername.equals(userName);
    }

    protected boolean authenticateJenkinsSystemUser(String password) {
        String adminPassword = "";
        try {
            adminPassword = AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty(JENKINS_SERVER_ADMIN_PASSWORD);
        }
        catch (AppFactoryException e) {
            Log.error((Object)"Error reading jenkins admin password from configuration");
        }
        return adminPassword.equals(password);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        throw new UsernameNotFoundException("loading users by name is not supported");
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        return new CarbonGroupDetails(this, groupname);
    }
}

