/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.jenkins;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.xml.stream.XMLStreamException;
import net.sf.json.JSONObject;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.wso2.carbon.appfactory.application.deployer.stub.ApplicationDeployerAppFactoryExceptionException;
import org.wso2.carbon.appfactory.application.deployer.stub.ApplicationDeployerStub;
import org.wso2.carbon.appfactory.build.stub.xsd.BuildStatusBean;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.common.util.AppFactoryUtil;
import org.wso2.carbon.appfactory.jenkins.build.notify.BuildStatusReceiverClient;
import org.wso2.carbon.utils.CarbonUtils;

public class AppfactoryPluginManager
extends Notifier
implements Serializable {
    private static final Log log = LogFactory.getLog(AppfactoryPluginManager.class);
    private final String applicationId;
    private final String applicationVersion;
    private final String applicationArtifactExtension;
    private final String userName;
    private final String repositoryFrom;
    private final String BUILDSTATUS_RECEIVER_NAME = "/services/BuildStatusRecieverService";

    @DataBoundConstructor
    public AppfactoryPluginManager(String applicationId, String applicationVersion, String applicationArtifactExtension, String userName, String repositoryFrom) {
        this.applicationId = applicationId;
        this.applicationVersion = applicationVersion;
        this.applicationArtifactExtension = applicationArtifactExtension;
        this.userName = userName;
        this.repositoryFrom = repositoryFrom;
        log.debug((Object)("Construct AppfactoryPluginManager  for : appid=" + applicationId + ",version=" + applicationVersion + ",applicationArtifactExtension=" + applicationArtifactExtension + ",username=" + userName + ", repoFrom=" + repositoryFrom));
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.append("The build started by " + this.userName + " for " + this.applicationId + " - " + this.applicationVersion + " in " + this.repositoryFrom + " is notified as " + build.getResult());
        String APPFACTORY_SERVER_URL = this.getDescriptor().getAppfactoryServerURL();
        String serviceURL = APPFACTORY_SERVER_URL + "/services/BuildStatusRecieverService";
        BuildStatusReceiverClient client = new BuildStatusReceiverClient(serviceURL, this.getDescriptor().getAdminUserName(), this.getDescriptor().getAdminPassword());
        String tenantUserName = (String)build.getBuildVariables().get("tenantUserName");
        BuildStatusBean buildStatus = this.createBuildStatusBean(build.getNumber(), tenantUserName);
        if (build.getResult() == Result.SUCCESS) {
            boolean doDeploy;
            buildStatus.setBuildSuccessful(true);
            buildStatus.setLogMsg("Build Successful");
            client.onBuildCompletion(buildStatus, tenantUserName);
            boolean isAutomatic = Boolean.parseBoolean((String)build.getEnvironment((TaskListener)listener).get((Object)"isAutomatic"));
            if (isAutomatic) {
                try {
                    String stage = this.getStage(this.applicationId, this.applicationVersion);
                    this.sendMessageToDeploy(this.applicationId, this.applicationVersion, "HEAD", stage, "autoDeployAction", tenantUserName, this.repositoryFrom);
                }
                catch (ApplicationDeployerAppFactoryExceptionException e) {
                    logger.append("Error while retrieving the deployment stage of application ").append(this.applicationId).append(" in version ").append(this.applicationVersion);
                    logger.append("Failed to deploy the artifact of automatic build");
                }
            }
            if (doDeploy = Boolean.parseBoolean((String)build.getEnvironment((TaskListener)listener).get((Object)"doDeploy"))) {
                String tagName = (String)build.getEnvironment((TaskListener)listener).get((Object)"tagName");
                String stage = (String)build.getEnvironment((TaskListener)listener).get((Object)"deployStage");
                String deployAction = "autoDeployAction";
                if (tagName != null && tagName != "") {
                    logger.append("sending message to deploy to stage ").append(stage).append(" with tag ").append(tagName);
                    this.sendMessageToDeploy(this.applicationId, this.applicationVersion, "HEAD", stage, deployAction, tenantUserName, this.repositoryFrom);
                } else {
                    logger.append("sending message to deploy to stage ").append(stage);
                    this.sendMessageToDeploy(this.applicationId, this.applicationVersion, "HEAD", stage, deployAction, tenantUserName, this.repositoryFrom);
                }
            } else {
                logger.append("DoDeploy is false");
            }
            logger.append("Successfully finished ").append(build.getFullDisplayName());
        } else {
            if (Boolean.parseBoolean((String)build.getEnvironment((TaskListener)listener).get((Object)"isAutomatic"))) {
                logger.append("This automatic build will not deploy any artifacts since the build failed for application ").append(this.applicationId).append(" in version " + this.applicationVersion);
            }
            buildStatus.setBuildSuccessful(false);
            buildStatus.setLogMsg("Build Failed");
            client.onBuildCompletion(buildStatus, tenantUserName);
            logger.append("Build failed ").append(build.getFullDisplayName());
        }
        boolean shouldPersist = Boolean.parseBoolean((String)build.getEnvironment((TaskListener)listener).get((Object)"persistArtifact"));
        if (shouldPersist) {
            String tagName = (String)build.getEnvironment((TaskListener)listener).get((Object)"tagName");
            if (tagName != null && !tagName.equals("")) {
                logger.append("Storing artifact permanently with the tag name ").append(tagName);
                FilePath[] files = build.getWorkspace().list("**/*." + this.applicationArtifactExtension);
                if (files != null && files.length > 0) {
                    FilePath sourceFilePath = files[0];
                    String filePath = this.getDescriptor().getStoragePath() + File.separator + (String)build.getEnvironment((TaskListener)listener).get((Object)"JOB_NAME") + File.separator + tagName;
                    File persistArtifact = new File(filePath);
                    if (!persistArtifact.mkdirs()) {
                        listener.getLogger().append("Unable to create the tag directory");
                    }
                    String targetFilePath = persistArtifact.getAbsolutePath() + File.separator + sourceFilePath.getName();
                    sourceFilePath.copyTo(new FilePath(new File(targetFilePath)));
                } else {
                    listener.getLogger().append("No artifacts were found to persist");
                }
            } else {
                logger.append("Cannot persist the artifact. Tag name cannot be null or empty");
            }
        } else {
            logger.append("Artifact is not stored permanently. persistArtifact = ").append(String.valueOf(shouldPersist));
        }
        return true;
    }

    private BuildStatusBean createBuildStatusBean(int buildId, String tenantUserName) {
        BuildStatusBean buildStatus = new BuildStatusBean();
        buildStatus.setApplicationId(this.applicationId);
        buildStatus.setVersion(this.applicationVersion);
        buildStatus.setArtifactType(this.applicationArtifactExtension);
        buildStatus.setUserName(this.userName);
        buildStatus.setTriggeredUser(tenantUserName);
        buildStatus.setRepoFrom(this.repositoryFrom);
        buildStatus.setBuildId(String.valueOf(buildId));
        return buildStatus;
    }

    private String getStage(String applicationId, String applicationVersion) throws ApplicationDeployerAppFactoryExceptionException, RemoteException {
        String applicationDeployerEPR = this.getDescriptor().getAppfactoryServerURL() + "/services/ApplicationDeployer";
        ApplicationDeployerStub clientStub = new ApplicationDeployerStub(applicationDeployerEPR);
        ServiceClient deployerClient = clientStub._getServiceClient();
        CarbonUtils.setBasicAccessSecurityHeaders((String)this.getDescriptor().getAdminUserName(), (String)this.getDescriptor().getAdminPassword(), (ServiceClient)deployerClient);
        String deployStage = clientStub.getStage(applicationId, applicationVersion);
        return deployStage;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void sendMessageToDeploy(final String applicationId, final String version, String revision, final String stage, final String deployAction, final String tenantUserName, final String repoFrom) {
        Thread clientCaller = new Thread(new Runnable(){

            @Override
            public void run() {
                String applicationDeployerEPR = AppfactoryPluginManager.this.getDescriptor().getAppfactoryServerURL() + "/services/ApplicationDeployer";
                ApplicationDeployerStub clientStub = null;
                try {
                    clientStub = new ApplicationDeployerStub(applicationDeployerEPR);
                    ServiceClient deployerClient = clientStub._getServiceClient();
                    AppFactoryUtil.setAuthHeaders((ServiceClient)deployerClient, (String)tenantUserName);
                    Thread.sleep(1000L);
                    clientStub.deployArtifact(applicationId, stage, version, "", deployAction, repoFrom);
                }
                catch (AxisFault e) {
                    log.error((Object)("Error while creating Application deployerStub " + e.getMessage()), (Throwable)e);
                }
                catch (RemoteException e) {
                    log.error((Object)("Error while sending deployment message " + e.getMessage()), (Throwable)e);
                }
                catch (ApplicationDeployerAppFactoryExceptionException e) {
                    log.error((Object)("Error while sending deployment message " + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.error((Object)("Error while sending deployment message " + e.getMessage()), (Throwable)e);
                }
                catch (AppFactoryException e) {
                    log.error((Object)("Error while sending deployment message " + e.getMessage()), (Throwable)e);
                }
            }
        });
        clientCaller.start();
    }

    private Policy getPolicy() throws XMLStreamException {
        String policyString = "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"\n\t\t\txmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\n\t\t\twsu:Id=\"UTOverTransport\">\n\t\t\t<wsp:ExactlyOne>\n\t\t\t\t<wsp:All>\n\t\t\t\t\t<sp:TransportBinding\n\t\t\t\t\t\txmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">\n\t\t\t\t\t\t<wsp:Policy>\n\t\t\t\t\t\t\t<sp:TransportToken>\n\t\t\t\t\t\t\t\t<wsp:Policy>\n\t\t\t\t\t\t\t\t\t<sp:HttpsToken RequireClientCertificate=\"false\" />\n\t\t\t\t\t\t\t\t</wsp:Policy>\n\t\t\t\t\t\t\t</sp:TransportToken>\n\t\t\t\t\t\t\t<sp:AlgorithmSuite>\n\t\t\t\t\t\t\t\t<wsp:Policy>\n\t\t\t\t\t\t\t\t\t<sp:Basic256 />\n\t\t\t\t\t\t\t\t</wsp:Policy>\n\t\t\t\t\t\t\t</sp:AlgorithmSuite>\n\t\t\t\t\t\t\t<sp:Layout>\n\t\t\t\t\t\t\t\t<wsp:Policy>\n\t\t\t\t\t\t\t\t\t<sp:Lax />\n\t\t\t\t\t\t\t\t</wsp:Policy>\n\t\t\t\t\t\t\t</sp:Layout>\n\t\t\t\t\t\t\t<sp:IncludeTimestamp />\n\t\t\t\t\t\t</wsp:Policy>\n\t\t\t\t\t</sp:TransportBinding>\n\t\t\t\t\t<sp:SignedSupportingTokens\n\t\t\t\t\t\txmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">\n\t\t\t\t\t\t<wsp:Policy>\n\t\t\t\t\t\t\t<sp:UsernameToken\n\t\t\t\t\t\t\t\tsp:IncludeToken=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient\" />\n\t\t\t\t\t\t</wsp:Policy>\n\t\t\t\t\t</sp:SignedSupportingTokens>\n\t\t\t\t\t<rampart:RampartConfig xmlns:rampart=\"http://ws.apache.org/rampart/policy\">\n\t\t\t\t\t\t<rampart:encryptionUser>useReqSigCert</rampart:encryptionUser>\n\t\t\t\t\t\t<rampart:timestampPrecisionInMilliseconds>true</rampart:timestampPrecisionInMilliseconds>\n\t\t\t\t\t\t<rampart:timestampTTL>300</rampart:timestampTTL>\n\t\t\t\t\t\t<rampart:timestampMaxSkew>300</rampart:timestampMaxSkew>\n\t\t\t\t\t\t<rampart:timestampStrict>false</rampart:timestampStrict>\n\t\t\t\t\t\t<rampart:passwordCallbackClass>org.wso2.carbon.appfactory.common.security.PWCBHandler</rampart:passwordCallbackClass>\n\t\t\t\t\t\t<rampart:tokenStoreClass>org.wso2.carbon.security.util.SecurityTokenStore</rampart:tokenStoreClass>\n\t\t\t\t\t\t<rampart:nonceLifeTime>300</rampart:nonceLifeTime>\n\t\t\t\t\t</rampart:RampartConfig>\n\t\t\t\t</wsp:All>\n\t\t\t</wsp:ExactlyOne>\n\t\t</wsp:Policy>";
        return PolicyEngine.getPolicy((OMElement)AXIOMUtil.stringToOM((String)policyString));
    }

    private static OMElement getPayload(String applicationId, String version, String revision, String stage, String tagName, String deployAction, boolean isAutomatic) throws XMLStreamException {
        String payload = tagName == null ? "<p:DeployArtifactRequest xmlns:p=\"http://wso2.org\"><p:applicationId>" + applicationId + "</p:applicationId>" + "<p:revision>" + revision + "</p:revision>" + "<p:version>" + version + "</p:version>" + "<p:stage>" + stage + "</p:stage>" + "<p:build>true</p:build>" + "<p:tagName></p:tagName>" + "<p:deployAction>" + deployAction + "</p:deployAction>" + "<p:automaticDeployment>" + Boolean.toString(isAutomatic) + "</p:automaticDeployment>" + "</p:DeployArtifactRequest>" : "<p:DeployArtifactRequest xmlns:p=\"http://wso2.org\"><p:applicationId>" + applicationId + "</p:applicationId>" + "<p:revision>" + revision + "</p:revision>" + "<p:version>" + version + "</p:version>" + "<p:stage>" + stage + "</p:stage>" + "<p:build>true</p:build>" + "<p:tagName>" + tagName + "</p:tagName>" + "<p:deployAction>" + deployAction + "</p:deployAction>" + "<p:automaticDeployment>" + Boolean.toString(isAutomatic) + "</p:automaticDeployment>" + "</p:DeployArtifactRequest>";
        return new StAXOMBuilder((InputStream)new ByteArrayInputStream(payload.getBytes())).getDocumentElement();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String deployBpelEPR;
        private String adminUserName;
        private String adminPassword;
        private String clientTrustStore;
        private String clientTrustStorePassword;
        private String appfactoryServerURL;
        private String storagePath;
        private String tempPath;

        public DescriptorImpl() {
            super(AppfactoryPluginManager.class);
            this.load();
        }

        public void setDeployBpelEPR(String deployBpelEPR) {
            this.deployBpelEPR = deployBpelEPR;
        }

        public void setAdminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
        }

        public void setAdminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
        }

        public FormValidation doCheckStoragePath(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set required fields");
            }
            File path = new File(value);
            FormValidation formValidation = path.isDirectory() ? FormValidation.ok() : FormValidation.error((String)"Invalid directory specified");
            return formValidation;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Appfactory Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.setDeployBpelEPR(formData.getString("deployBpelEPR"));
            this.setAdminUserName(formData.getString("adminUserName"));
            this.setAdminPassword(formData.getString("adminPassword"));
            this.setClientTrustStore(formData.getString("clientTrustStore"));
            this.setClientTrustStorePassword(formData.getString("clientTrustStorePassword"));
            this.setAppfactoryServerURL(formData.getString("appfactoryServerURL"));
            this.setStoragePath(formData.getString("storagePath"));
            this.setTempPath(formData.getString("tempPath"));
            this.save();
            return super.configure(req, formData);
        }

        public String getDeployBpelEPR() {
            return this.deployBpelEPR;
        }

        public String getAdminUserName() {
            return this.adminUserName;
        }

        public String getAdminPassword() {
            return this.adminPassword;
        }

        public String getClientTrustStore() {
            return this.clientTrustStore;
        }

        public void setClientTrustStore(String clientTrustStore) {
            this.clientTrustStore = clientTrustStore;
        }

        public String getClientTrustStorePassword() {
            return this.clientTrustStorePassword;
        }

        public void setClientTrustStorePassword(String clientTrustStorePassword) {
            this.clientTrustStorePassword = clientTrustStorePassword;
        }

        public String getAppfactoryServerURL() {
            return this.appfactoryServerURL;
        }

        public void setAppfactoryServerURL(String appfactoryServerURL) {
            this.appfactoryServerURL = appfactoryServerURL;
        }

        public String getStoragePath() {
            return this.storagePath;
        }

        public void setStoragePath(String storagePath) {
            if (storagePath.endsWith("/") | storagePath.endsWith("\\")) {
                storagePath = storagePath.substring(0, storagePath.length() - 1);
            }
            this.storagePath = storagePath;
        }

        public String getTempPath() {
            return this.tempPath;
        }

        public void setTempPath(String tempPath) {
            this.tempPath = tempPath;
        }
    }
}

