/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.jenkins.api;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.common.util.AppFactoryUtil;
import org.wso2.carbon.appfactory.deployers.build.api.BuildStatusProvider;
import org.wso2.carbon.appfactory.deployers.build.api.BuildStatusProviderException;
import org.wso2.carbon.appfactory.jenkins.artifact.storage.Utils;
import org.wso2.carbon.appfactory.jenkins.util.JenkinsUtility;

public class JenkinsBuildStatusProvider
implements BuildStatusProvider {
    private static final Log log = LogFactory.getLog(JenkinsBuildStatusProvider.class);
    private HttpClient client = null;

    public Map<String, String> getLastBuildInformation(String applicationId, String version, String userName, String repoFrom) throws BuildStatusProviderException {
        Map<String, String> buildInformarion;
        block11: {
            String jobName = JenkinsUtility.getJobName(applicationId, version, userName, repoFrom);
            String url = null;
            try {
                url = AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("ContinuousIntegrationProvider.jenkins.Property.BaseURL");
            }
            catch (AppFactoryException e) {
                String msg = "Error occuered while calling the API";
                throw new BuildStatusProviderException(msg);
            }
            String tenantDomain = Utils.getEnvironmentVariable("TENANT_DOMAIN");
            url = url + "/t/" + tenantDomain + "/webapps/jenkins/" + "job/" + jobName + "/api/json";
            log.info((Object)("Calling jenkins api : " + url));
            GetMethod get = new GetMethod(url);
            NameValuePair valuePair = new NameValuePair("tree", "builds[number,status,timestamp,id,result]");
            get.setQueryString(new NameValuePair[]{valuePair});
            try {
                this.getHttpClient().getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("JenkinsServerAdminUsername"), AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("JenkinsServerAdminPassword")));
            }
            catch (AppFactoryException e) {
                String msg = "Error occuered while calling the API";
                throw new BuildStatusProviderException(msg);
            }
            this.getHttpClient().getParams().setAuthenticationPreemptive(true);
            buildInformarion = null;
            try {
                log.debug((Object)("Retrieving last build information for job : " + jobName));
                this.getHttpClient().executeMethod((HttpMethod)get);
                log.info((Object)("Retrieving last build information for job : " + jobName + " status received : " + get.getStatusCode()));
                if (get.getStatusCode() == 200) {
                    String response = get.getResponseBodyAsString();
                    log.debug((Object)("Returns build information for job : " + jobName + " - " + response));
                    buildInformarion = this.extractBuildInformarion(response);
                    break block11;
                }
                String msg = "Error while retrieving  build information for job : " + jobName + " Jenkins returned status code : " + get.getStatusCode();
                log.error((Object)msg);
                throw new BuildStatusProviderException(msg, 101);
            }
            catch (HttpException e) {
                String msg = "Error occuered while calling the API";
                throw new BuildStatusProviderException(msg);
            }
            catch (IOException e) {
                String msg = "Error occuered while calling the API";
                throw new BuildStatusProviderException(msg);
            }
            finally {
                get.releaseConnection();
            }
        }
        return buildInformarion;
    }

    private Map<String, String> extractBuildInformarion(String response) {
        Gson gson = new Gson();
        Map buildInfoMap = (Map)gson.fromJson(response, new TypeToken<Map<String, List<Map<String, String>>>>(){}.getType());
        List buildList = (List)buildInfoMap.get("builds");
        if (buildList.size() > 0) {
            return (Map)buildList.get(0);
        }
        return null;
    }

    private HttpClient getHttpClient() {
        if (this.client == null) {
            this.client = new HttpClient();
        }
        return this.client;
    }

    void setHttpClient(HttpClient client) {
        this.client = client;
    }

    public String getLastSuccessfulBuildId(String applicationId, String version, String userName, String repoFrom) throws BuildStatusProviderException {
        String jobName = JenkinsUtility.getJobName(applicationId, version);
        String buildUrl = "";
        try {
            buildUrl = AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("ContinuousIntegrationProvider.jenkins.Property.BaseURL");
        }
        catch (AppFactoryException e) {
            String msg = "Error occuered while calling the API";
            throw new BuildStatusProviderException(msg);
        }
        String tenantDomain = Utils.getEnvironmentVariable("TENANT_DOMAIN");
        buildUrl = buildUrl + "/t/" + tenantDomain + "/webapps/jenkins/" + "job/" + jobName + "/api/xml";
        String lastSuccessBuildId = null;
        GetMethod checkJobExistsMethod = new GetMethod(buildUrl);
        try {
            this.getHttpClient().getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("JenkinsServerAdminUsername"), AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("JenkinsServerAdminPassword")));
        }
        catch (AppFactoryException e) {
            String msg = "Error occuered while calling the API";
            throw new BuildStatusProviderException(msg);
        }
        this.getHttpClient().getParams().setAuthenticationPreemptive(true);
        try {
            OMElement lastSuccessfulBuild;
            int httpStatusCode = this.getHttpClient().executeMethod((HttpMethod)checkJobExistsMethod);
            if (503 == httpStatusCode) {
                httpStatusCode = this.resendRequest(checkJobExistsMethod);
            }
            if (200 != httpStatusCode) {
                String errorMsg = String.format("Unable to check the status  of build: [%s]. jenkins returned, http status : %d", buildUrl, httpStatusCode);
                log.error((Object)errorMsg);
                throw new BuildStatusProviderException(errorMsg);
            }
            StAXOMBuilder builder = new StAXOMBuilder(checkJobExistsMethod.getResponseBodyAsStream());
            OMElement resultElement = builder.getDocumentElement();
            if (resultElement != null && (lastSuccessfulBuild = resultElement.getFirstChildWithName(new QName("lastSuccessfulBuild"))) != null) {
                lastSuccessBuildId = lastSuccessfulBuild.getFirstChildWithName(new QName("number")).getText();
            }
        }
        catch (Exception ex) {
            String errorMsg = "Error while checking the status of build: " + buildUrl;
            log.error((Object)errorMsg, (Throwable)ex);
            throw new BuildStatusProviderException(errorMsg);
        }
        finally {
            checkJobExistsMethod.releaseConnection();
        }
        return lastSuccessBuildId;
    }

    private int resendRequest(GetMethod method) throws AppFactoryException {
        int httpStatusCode = -1;
        try {
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(10000L);
                log.info((Object)"Resending request...");
                httpStatusCode = this.getHttpClient().executeMethod((HttpMethod)method);
                if (200 != httpStatusCode) continue;
                log.info((Object)("Break resending since " + httpStatusCode));
                break;
            }
        }
        catch (IOException e) {
            String errorMsg = "Error while resending the request";
            log.error((Object)errorMsg, (Throwable)e);
            throw new AppFactoryException(errorMsg, (Throwable)e);
        }
        catch (InterruptedException e) {
            String errorMsg = "Error while resending the request";
            log.error((Object)errorMsg, (Throwable)e);
            throw new AppFactoryException(errorMsg, (Throwable)e);
        }
        return httpStatusCode;
    }
}

