/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.jenkins.artifact.storage;

import hudson.Plugin;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportedBean;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.core.Deployer;
import org.wso2.carbon.appfactory.core.Undeployer;
import org.wso2.carbon.appfactory.deployers.util.DeployerUtil;
import org.wso2.carbon.appfactory.jenkins.artifact.storage.Utils;
import org.wso2.carbon.appfactory.jenkins.util.JenkinsUtility;

@ExportedBean
public class AppfactoryArtifactStoragePlugin
extends Plugin {
    private static final Log log = LogFactory.getLog(AppfactoryArtifactStoragePlugin.class);
    private static final String UNDEPLOY_ARTIFACT_ACTION = "/undeployArtifact";
    private static final String DEPLOY_PROMOTED_ARTIFACT_ACTION = "/deployPromotedArtifact";
    private static final String DEPLOY_LATEST_SUCCESS_ARTIFACT_ACTION = "/deployLatestSuccessArtifact";

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        block10: {
            String action = req.getRestOfPath();
            if ("/getTagNamesOfPersistedArtifacts".equals(action)) {
                Utils.getTagNamesOfPersistedArtifacts(req, rsp);
            } else {
                String jobName = req.getParameter("jobName");
                String stage = req.getParameter("deployAction");
                String applicationId = JenkinsUtility.getApplicationId(jobName);
                String version = JenkinsUtility.getVersion(jobName);
                String runtime = null;
                String className = null;
                try {
                    Map<String, String[]> map = Utils.getParameterMapFromRequest(req);
                    map.put("applicationId", new String[]{applicationId});
                    map.put("version", new String[]{version});
                    runtime = DeployerUtil.getParameter(map, (String)"runtimesNameForApptype");
                    ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                    if (DEPLOY_LATEST_SUCCESS_ARTIFACT_ACTION.equals(action)) {
                        className = DeployerUtil.getParameter(map, (String)"DeployerClassName");
                        Deployer deployer = this.getDeployer(className, loader);
                        deployer.deployLatestSuccessArtifact(map);
                        break block10;
                    }
                    if (DEPLOY_PROMOTED_ARTIFACT_ACTION.equals(action)) {
                        className = DeployerUtil.getParameter(map, (String)"DeployerClassName");
                        Deployer deployer = this.getDeployer(className, loader);
                        deployer.deployPromotedArtifact(map);
                        break block10;
                    }
                    rsp.setStatus(400);
                    throw new ServletException("Invalid action");
                }
                catch (AppFactoryException e) {
                    String msg = "Action " + action + "failed for the job name : " + jobName + ", application id : " + applicationId + ", version : " + version + " in  stage : " + stage + " and runtime : " + runtime;
                    throw new ServletException(msg, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    String msg = "Action " + action + "failed for the job name : " + jobName + ", application id : " + applicationId + ", version : " + version + " in  stage : " + stage + " and runtime : " + runtime;
                    throw new ServletException(msg, (Throwable)e);
                }
                catch (InstantiationException e) {
                    String msg = "Action " + action + "failed for the job name : " + jobName + ", application id : " + applicationId + ", version : " + version + " in  stage : " + stage + " and runtime : " + runtime + ".\n Error occurred while getting an instance of the provided class: " + className;
                    throw new ServletException(msg, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    String msg = "Action " + action + "failed for the job name : " + jobName + ", application id : " + applicationId + ", version : " + version + " in  stage : " + stage + " and runtime : " + runtime;
                    throw new ServletException(msg, (Throwable)e);
                }
                catch (Exception e) {
                    String msg = "Action " + action + "failed for the job name : " + jobName + ", application id : " + applicationId + ", version : " + version + " in  stage : " + stage + " and runtime : " + runtime;
                    throw new ServletException(msg, (Throwable)e);
                }
            }
        }
    }

    private Undeployer getUndeployer(String className, ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
        Object undeployerObj = this.getClassInstance(loader, className);
        if (undeployerObj instanceof Undeployer) {
            return (Undeployer)undeployerObj;
        }
        String msg = "Undeployer class name should be a implementation of " + Undeployer.class + ", but we found " + className;
        throw new ServletException(msg);
    }

    private Deployer getDeployer(String className, ClassLoader loader) throws ServletException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object deployerObject = this.getClassInstance(loader, className);
        if (deployerObject instanceof Deployer) {
            return (Deployer)deployerObject;
        }
        String msg = "Deployer class name should be a implementation of " + Deployer.class + ", but we found " + className;
        throw new ServletException(msg);
    }

    private Object getClassInstance(ClassLoader loader, String className) throws ServletException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (StringUtils.isEmpty((String)className)) {
            throw new ServletException("Name of the class to be loaded, is not passed with parameters for deployment/undeployment.");
        }
        Class<?> customCodeClass = Class.forName(className, true, loader);
        return customCodeClass.newInstance();
    }
}

