/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.jenkins.artifact.storage;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.wso2.carbon.appfactory.jenkins.artifact.storage.PersistArtifactHandlerConfig;

public class PersistArtifactHandler
implements FilePath.FileCallable<Boolean> {
    private PersistArtifactHandlerConfig artifactHandlerConfig;

    public PersistArtifactHandler(PersistArtifactHandlerConfig artifactHandlerConfig) {
        this.artifactHandlerConfig = artifactHandlerConfig;
    }

    public Boolean invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
        File target;
        String[] ext = new String[]{this.artifactHandlerConfig.getApplicationArtifactExtension()};
        if (file != null && (target = (File)FileUtils.listFiles((File)file, (String[])ext, (boolean)true).iterator().next()) != null && new File(this.artifactHandlerConfig.getPersistentStoragePath()).exists()) {
            File persistArtifact = new File(this.artifactHandlerConfig.getPersistentStoragePath() + File.separator + this.artifactHandlerConfig.getJobName() + File.separator + this.artifactHandlerConfig.getTagName());
            persistArtifact.mkdirs();
            this.copyArtifact(target.getAbsolutePath(), persistArtifact.getAbsolutePath() + File.separator + target.getName());
        }
        return true;
    }

    private void copyArtifact(String source, String destination) throws IOException {
        int length;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        byte[] buffer = new byte[1024];
        while ((length = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

