/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.jenkins.artifact.storage;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.wso2.carbon.appfactory.jenkins.AppfactoryPluginManager;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static AppfactoryPluginManager.DescriptorImpl descriptor = new AppfactoryPluginManager.DescriptorImpl();

    public static void getTagNamesOfPersistedArtifacts(StaplerRequest req, StaplerResponse rsp) {
        String storagePath = descriptor.getStoragePath();
        String jobName = req.getParameter("jobName");
        File jobDir = new File(storagePath + File.separator + jobName);
        String[] identifiers = jobDir.list();
        if (jobDir.exists() && identifiers.length > 0) {
            try {
                PrintWriter writer = rsp.getWriter();
                for (String identifier : identifiers) {
                    writer.write(identifier + ",");
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while adding identifiers to response", (Throwable)e);
            }
        } else {
            log.info((Object)("No artifacts are tagged to persists for job " + jobName));
        }
    }

    public static Map<String, String[]> getParameterMapFromRequest(StaplerRequest request) {
        HashMap<String, String[]> retMap = new HashMap<String, String[]>();
        Map currentMap = request.getParameterMap();
        if (currentMap != null) {
            retMap.putAll(currentMap);
            String rootPath = request.getRootPath();
            retMap.put("rootPath", new String[]{rootPath});
        }
        return retMap;
    }

    public static String getEnvironmentVariable(String variableName) {
        String variableValue = null;
        try {
            InitialContext iniCtxt = new InitialContext();
            Context env = (Context)iniCtxt.lookup("java:comp/env");
            variableValue = (String)env.lookup(variableName);
        }
        catch (NamingException e) {
            log.error((Object)("Unable to read " + variableName + " from the environment"));
        }
        return variableValue;
    }
}

