/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.jenkins.build.notify;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.build.stub.BuildStatusRecieverServiceAppFactoryExceptionException;
import org.wso2.carbon.appfactory.build.stub.BuildStatusRecieverServiceStub;
import org.wso2.carbon.appfactory.build.stub.xsd.BuildStatusBean;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BuildStatusReceiverClient {
    private static final Log log = LogFactory.getLog(BuildStatusReceiverClient.class);
    private BuildStatusRecieverServiceStub clientStub;

    public BuildStatusReceiverClient(String epr, String username, String password) {
        try {
            this.clientStub = new BuildStatusRecieverServiceStub(epr);
        }
        catch (AxisFault e) {
            String msg = "Error occurred while initializing BuildStatusRecieverServiceStub";
            log.error((Object)msg, (Throwable)e);
        }
        ServiceClient client = this.clientStub._getServiceClient();
        CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (ServiceClient)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBuildCompletion(BuildStatusBean buildStatus, String tenantUserName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(buildStatus.getApplicationId() + " build completed for the buildId " + buildStatus.getBuildId()));
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)tenantUserName);
        try {
            this.clientStub.onBuildCompletion(buildStatus, tenantDomain);
        }
        catch (RemoteException e) {
            String msg = "Failed to send the build status for application " + buildStatus.getApplicationId();
            log.error((Object)msg, (Throwable)e);
        }
        catch (BuildStatusRecieverServiceAppFactoryExceptionException e) {
            String msg = "Error occurred while executing onBuildCompletion method in server side";
            log.error((Object)msg, (Throwable)e);
        }
        finally {
            try {
                this.clientStub._getServiceClient().cleanupTransport();
                this.clientStub._getServiceClient().cleanup();
            }
            catch (AxisFault e) {
                log.error((Object)"Failed to clean up buildStatusReceiverServiceStub", (Throwable)e);
            }
        }
    }
}

