/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.jenkins.deploy;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.common.util.AppFactoryUtil;
import org.wso2.carbon.appfactory.deployers.AbstractStratosDeployer;
import org.wso2.carbon.appfactory.deployers.notify.DeployNotifier;
import org.wso2.carbon.appfactory.deployers.util.DeployerUtil;
import org.wso2.carbon.appfactory.eventing.AppFactoryEventException;
import org.wso2.carbon.appfactory.eventing.EventNotifier;
import org.wso2.carbon.appfactory.eventing.builder.utils.ContinousIntegrationEventBuilderUtil;
import org.wso2.carbon.appfactory.jenkins.AppfactoryPluginManager;
import org.wso2.carbon.appfactory.jenkins.api.JenkinsBuildStatusProvider;
import org.wso2.carbon.appfactory.jenkins.artifact.storage.Utils;
import org.wso2.carbon.appfactory.jenkins.util.JenkinsUtility;

public class JenkinsArtifactDeployer
extends AbstractStratosDeployer {
    private static final Log log = LogFactory.getLog(JenkinsArtifactDeployer.class);
    protected AppfactoryPluginManager.DescriptorImpl descriptor = new AppfactoryPluginManager.DescriptorImpl();

    public JenkinsArtifactDeployer() {
        super.setAdminUserName(this.descriptor.getAdminUserName());
        super.setAdminPassword(this.descriptor.getAdminPassword());
        super.setAppfactoryServerURL(this.descriptor.getAppfactoryServerURL());
        super.setStoragePath(this.descriptor.getStoragePath());
        super.setTempPath(this.descriptor.getTempPath());
        this.buildStatusProvider = new JenkinsBuildStatusProvider();
        String tenantDomain = Utils.getEnvironmentVariable("TENANT_DOMAIN");
        String tenantID = Utils.getEnvironmentVariable("TENANT_ID");
        super.setTenantDomain(tenantDomain);
        super.setTenantID(Integer.parseInt(tenantID));
    }

    public void deployLatestSuccessArtifact(Map<String, String[]> parameters) throws AppFactoryException {
        String applicationId = DeployerUtil.getParameter(parameters, (String)"applicationId");
        String stageName = DeployerUtil.getParameter(parameters, (String)"deployStage");
        String deployAction = DeployerUtil.getParameter(parameters, (String)"deployAction");
        String artifactType = DeployerUtil.getParameter(parameters, (String)"artifactType");
        String version = DeployerUtil.getParameter(parameters, (String)"version");
        String serverDeploymentPath = DeployerUtil.getParameter(parameters, (String)"ServerDeploymentPaths");
        log.info((Object)("Server deployment path is : " + serverDeploymentPath));
        String jobName = DeployerUtil.getParameter(parameters, (String)"jobName");
        String repositoryFrom = DeployerUtil.getParameter(parameters, (String)"repositoryFrom");
        String path = this.getSuccessfulArtifactTempStoragePath(applicationId, version, artifactType, stageName, this.getTenantDomain(), jobName);
        File lastSuccess = new File(path);
        if (!lastSuccess.exists()) {
            try {
                String tenantDomain = this.getTenantDomain();
                String correlationKey = applicationId + stageName + version + tenantDomain;
                EventNotifier.getInstance().notify(ContinousIntegrationEventBuilderUtil.autoDeployStatusChangeEvent((String)applicationId, (String)tenantDomain, (String)"Application deployment couldn't be done, please try again.", (String)"", (String)correlationKey));
            }
            catch (AppFactoryEventException e) {
                log.error((Object)("Failed to notify deployment of latest successful artifact " + e.getMessage()), (Throwable)e);
            }
        } else {
            log.info((Object)("Deploying Last Successful Artifact with job name - " + jobName + " stageName -" + stageName + " deployAction -" + deployAction));
            try {
                if (!"fork".equals(repositoryFrom)) {
                    String tenantDomain = this.getTenantDomain();
                    String correlationKey = applicationId + stageName + version + tenantDomain;
                    EventNotifier.getInstance().notify(ContinousIntegrationEventBuilderUtil.buildApplicationDeployementStartedEvent((String)applicationId, (String)tenantDomain, (String)("Application deployment started for " + version + " of " + repositoryFrom + " repo"), null, (String)correlationKey));
                }
                super.deployLatestSuccessArtifact(parameters);
            }
            catch (AppFactoryException e) {
                String msg = "deployment of latest success artifact failed for applicaion " + jobName;
                this.handleException(msg, (Exception)((Object)e));
            }
            catch (AppFactoryEventException e) {
                log.error((Object)("Failed to notify deployment of latest successful artifact " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void triggerBuild(String jobName, String buildUrl, NameValuePair[] queryParameters) throws AppFactoryException {
        PostMethod buildMethod = new PostMethod(buildUrl);
        buildMethod.setDoAuthentication(true);
        if (queryParameters != null) {
            buildMethod.setQueryString(queryParameters);
        }
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getAdminUsername(), this.getServerAdminPassword()));
        httpClient.getParams().setAuthenticationPreemptive(true);
        int httpStatusCode = -1;
        try {
            httpStatusCode = httpClient.executeMethod((HttpMethod)buildMethod);
        }
        catch (Exception ex) {
            String errorMsg = String.format("Unable to start the build on job : %s", jobName);
            log.error((Object)errorMsg);
            throw new AppFactoryException(errorMsg, (Throwable)ex);
        }
        finally {
            buildMethod.releaseConnection();
        }
        if (403 == httpStatusCode) {
            String errorMsg = "Unable to start a build for job [".concat(jobName).concat("] due to invalid credentials.").concat("Jenkins returned, http status : [").concat(String.valueOf(httpStatusCode)).concat("]");
            log.error((Object)errorMsg);
            throw new AppFactoryException(errorMsg);
        }
        if (404 == httpStatusCode) {
            String errorMsg = "Unable to find the job [" + jobName + "Jenkins returned, " + "http status : [" + httpStatusCode + "]";
            log.error((Object)errorMsg);
            throw new AppFactoryException(errorMsg);
        }
    }

    public void labelLastSuccessAsPromoted(String applicationId, String version, String artifactType, String extension, String jobName) throws AppFactoryException, IOException, InterruptedException {
        File[] lastSucessFiles;
        log.info((Object)"---------------------------Entering Deploy Procedure --------------------------");
        String lastSucessBuildFilePath = this.getSuccessfulArtifactTempStoragePath(applicationId, version, artifactType, null, null, jobName);
        log.debug((Object)("Last success build path is :" + lastSucessBuildFilePath));
        String dest = this.getArtifactStoragePath(applicationId, version, artifactType, null, null);
        File destDir = new File(dest);
        if (destDir.exists()) {
            FileUtils.cleanDirectory((File)destDir.getParentFile());
        }
        if (!destDir.mkdirs()) {
            log.error((Object)("Unable to create promoted tag for application :" + applicationId + ", version :" + version));
            throw new AppFactoryException("Error occured while creating dir for last successful as PROMOTED: application :" + applicationId + ", version :" + version);
        }
        for (File lastSucessFile : lastSucessFiles = this.getLastBuildArtifact(lastSucessBuildFilePath, extension)) {
            FilePath lastSuccessArtifactPath = new FilePath(lastSucessFile);
            String promotedDestDirPath = destDir.getAbsolutePath();
            File promotedDestDir = new File(promotedDestDirPath);
            FilePath promotedDestDirFilePath = new FilePath(promotedDestDir);
            if (!promotedDestDirFilePath.exists()) {
                promotedDestDirFilePath.mkdirs();
            }
            File destFile = new File(promotedDestDir.getAbsolutePath() + File.separator + lastSuccessArtifactPath.getName());
            FilePath destinationFile = new FilePath(destFile);
            if (lastSuccessArtifactPath.isDirectory()) {
                lastSuccessArtifactPath.copyRecursiveTo(destinationFile);
            } else {
                lastSuccessArtifactPath.copyTo(destinationFile);
            }
            log.info((Object)"labeled the lastSuccessful as PROMOTED");
        }
    }

    public void labelAsPromotedArtifact(String jobName, String tagName) {
        try {
            File destDir;
            String path = this.descriptor.getStoragePath() + File.separator + jobName + File.separator + tagName;
            FilePath tagPath = new FilePath(new File(path));
            String jobPromotedPath = this.descriptor.getStoragePath() + File.separator + "PROMOTED" + File.separator + jobName;
            String dest = jobPromotedPath + File.separator + tagName;
            File toBeCleaned = new File(jobPromotedPath);
            if (toBeCleaned.exists()) {
                FileUtils.cleanDirectory((File)toBeCleaned);
            }
            if (!(destDir = new File(dest)).mkdirs()) {
                log.error((Object)("Unable to create promoted tag for job:" + jobName + "tag:" + tagName));
            }
            tagPath.copyRecursiveTo(new FilePath(destDir));
            log.info((Object)("labeled the tag: " + tagName + " as PROMOTED"));
        }
        catch (Exception e) {
            log.error((Object)("Error while labeling the tag: " + tagName + "as PROMOTED"), (Throwable)e);
        }
    }

    public String getSuccessfulArtifactTempStoragePath(String applicationId, String applicationVersion, String artifactType, String stage, String tenantDomain, String jobName) throws AppFactoryException {
        String jenkinsHome = null;
        try {
            jenkinsHome = DeployerUtil.getJenkinsHome();
        }
        catch (NamingException e) {
            String msg = "Error while reading jenkins home from context";
            log.error((Object)msg, (Throwable)e);
            throw new AppFactoryException(msg, (Throwable)e);
        }
        String path = jenkinsHome + File.separator + "jobs" + File.separator + jobName + File.separator + "lastSuccessful";
        return path;
    }

    public String getArtifactStoragePath(String applicationId, String applicationVersion, String artifactType, String stage, String tenantDomain) throws AppFactoryException {
        String jobName = JenkinsUtility.getJobName(applicationId, applicationVersion);
        String path = this.getStoragePath() + File.separator + "PROMOTED" + File.separator + jobName + File.separator + "lastSuccessful";
        return path;
    }

    public void postDeploymentNoifier(String message, String applicationId, String applicationVersion, String artifactType, String stage, String tenantDomain) {
        try {
            log.info((Object)("Application Deployed Successfully. Application ID :" + applicationId + " and version : " + applicationVersion));
            DeployNotifier notifier = new DeployNotifier();
            notifier.deployed(applicationId, applicationVersion, stage, this.adminUserName, this.adminPassword, this.appfactoryServerURL, this.buildStatusProvider, tenantDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getBaseRepoUrl() throws AppFactoryException {
        return AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("PAASArtifactStorageRepositoryProvider.BaseURL");
    }

    protected String getAdminPassword() throws AppFactoryException {
        return AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("PAASArtifactStorageRepositoryProvider.AdminPassword");
    }

    protected String getAdminUserName() throws AppFactoryException {
        return AppFactoryUtil.getAppfactoryConfiguration().getFirstProperty("PAASArtifactStorageRepositoryProvider.AdminUserName");
    }

    public void deployTaggedArtifact(Map<String, String[]> requestParameters) throws Exception {
    }
}

