/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.git.ApplicationManagementServiceClient;
import org.wso2.carbon.appfactory.git.ContextHolder;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.appfactory.git.util.Util;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;

public class AppFactoryAuthenticationClient {
    private static final Logger log = LoggerFactory.getLogger(ApplicationManagementServiceClient.class);
    private AuthenticationAdminStub serviceStub;
    private GitBlitConfiguration gitBlitConfiguration;

    public AppFactoryAuthenticationClient(GitBlitConfiguration configuration) {
        this.gitBlitConfiguration = configuration;
        try {
            ConfigurationContext context = ContextHolder.getHolder(this.gitBlitConfiguration).getConfigurationContext();
            this.serviceStub = new AuthenticationAdminStub(context, configuration.getProperty("appfactory.url", "https://localhost:9443") + "/services/AuthenticationAdmin");
            Util.setMaxTotalConnection(this.serviceStub._getServiceClient());
        }
        catch (AxisFault fault) {
            log.error("Error occurred while initializing client ", (Throwable)fault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String userName, String password) {
        boolean isAuth = false;
        String cookie = null;
        try {
            if (this.serviceStub.login(userName, password, null)) {
                ServiceContext serviceContext = this.serviceStub._getServiceClient().getLastOperationContext().getServiceContext();
                cookie = (String)serviceContext.getProperty("Cookie");
                isAuth = true;
            }
        }
        catch (AxisFault e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LoginAuthenticationExceptionException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                this.serviceStub._getServiceClient().cleanupTransport();
                this.serviceStub._getServiceClient().cleanup();
                this.serviceStub.cleanup();
            }
            catch (AxisFault fault) {}
        }
        return isAuth ? cookie : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        try {
            this.serviceStub.logout();
        }
        catch (RemoteException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LogoutAuthenticationExceptionException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                this.serviceStub._getServiceClient().cleanupTransport();
                this.serviceStub._getServiceClient().cleanup();
                this.serviceStub.cleanup();
            }
            catch (AxisFault fault) {}
        }
    }
}

