/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.git.AppFactoryRepositoryAuthorizationClient;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.appfactory.gitblit.oauth.oauth2.AppFactoryGitBlitAuthenticationProvider;

public class AppFactoryGitBlitUserModel
extends UserModel {
    private static final Logger log = LoggerFactory.getLogger(AppFactoryGitBlitUserModel.class);
    private transient AppFactoryRepositoryAuthorizationClient appFactoryRepositoryAuthorizationClient;
    private transient GitBlitConfiguration configuration;
    private Map<String, Boolean> accessPermissionMap = new HashMap<String, Boolean>();

    public String getAdminCookie() {
        return this.cookie;
    }

    public void setAdminCookie(String adminCookie) {
        this.cookie = adminCookie;
    }

    public GitBlitConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GitBlitConfiguration configuration) {
        this.configuration = configuration;
    }

    public AppFactoryGitBlitUserModel(String username) {
        super(username);
    }

    public AppFactoryGitBlitUserModel(String username, GitBlitConfiguration config, AppFactoryRepositoryAuthorizationClient appFactoryRepositoryAuthorizationClient) {
        this(username);
        this.appFactoryRepositoryAuthorizationClient = appFactoryRepositoryAuthorizationClient;
        this.configuration = config;
    }

    protected boolean canAccess(RepositoryModel repository, Constants.AccessRestrictionType ifRestriction, Constants.AccessPermission requirePermission) {
        boolean canAccess = true;
        if (!this.username.equals(this.configuration.getProperty("appfactory.gitblit.admin.username", "admin"))) {
            if (this.getAdminCookie() != null && !this.getAdminCookie().equals("")) {
                this.appFactoryRepositoryAuthorizationClient.setCookie(this.getAdminCookie());
            }
            String appName = AppFactoryGitBlitAuthenticationProvider.getAppFactoryApplicationName(repository.name);
            canAccess = this.appFactoryRepositoryAuthorizationClient.authorize(this.getName(), appName, requirePermission.code, repository.name);
        }
        log.debug("Accessibility  to code : " + requirePermission.code + " is " + canAccess);
        return canAccess;
    }

    public AppFactoryRepositoryAuthorizationClient getAppFactoryRepositoryAuthorizationClient() {
        return new AppFactoryRepositoryAuthorizationClient(this.getConfiguration());
    }

    public void setAppFactoryRepositoryAuthorizationClient(AppFactoryRepositoryAuthorizationClient appFactoryRepositoryAuthorizationClient) {
        this.appFactoryRepositoryAuthorizationClient = appFactoryRepositoryAuthorizationClient;
    }
}

