/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.common.util.AppFactoryUtil;
import org.wso2.carbon.appfactory.git.ApplicationManagementServiceClient;
import org.wso2.carbon.appfactory.git.ContextHolder;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.appfactory.repository.mgt.service.RepositoryAuthenticationServiceStub;

public class AppFactoryRepositoryAuthorizationClient {
    private static final Logger log = LoggerFactory.getLogger(ApplicationManagementServiceClient.class);
    private RepositoryAuthenticationServiceStub serviceStub;
    private GitBlitConfiguration gitBlitConfiguration;
    private ContextHolder holder;

    public AppFactoryRepositoryAuthorizationClient(GitBlitConfiguration configuration) {
        this.gitBlitConfiguration = configuration;
        this.holder = ContextHolder.getHolder(this.gitBlitConfiguration);
        try {
            ConfigurationContext context = this.holder.getConfigurationContext();
            this.serviceStub = new RepositoryAuthenticationServiceStub(context, configuration.getProperty("appfactory.url", "https://localhost:9443") + "/services/RepositoryAuthenticationService");
        }
        catch (AxisFault fault) {
            log.error("Error occurred while initializing client ", (Throwable)fault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(String userName, String repositoryName, String repositoryAction, String fullRepoName) {
        boolean isAuth = false;
        try {
            log.info("User: " + userName + " is authorizing for " + repositoryName);
            String repoDomain = fullRepoName.split("/")[0];
            String tenantDomain = userName.substring(userName.lastIndexOf("@") + 1);
            if (!repoDomain.equals(tenantDomain) & !repoDomain.equals("~" + tenantDomain)) {
                boolean bl = false;
                return bl;
            }
            AppFactoryUtil.setAuthHeaders((ServiceClient)this.serviceStub._getServiceClient(), (String)userName);
            if (this.serviceStub.hasAccess(userName, repositoryName, repositoryAction, fullRepoName)) {
                log.info("User: " + userName + " is authorized for " + repositoryName);
                isAuth = true;
            }
        }
        catch (AxisFault e) {
            log.error("Error while calling RepositoryAuthenticationService: Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            log.error("Error while calling RepositoryAuthenticationService: Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AppFactoryException e) {
            log.error("Error while calling RepositoryAuthenticationService: Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                this.serviceStub._getServiceClient().cleanupTransport();
                this.serviceStub._getServiceClient().cleanup();
                this.serviceStub.cleanup();
            }
            catch (AxisFault fault) {}
        }
        return isAuth;
    }

    public void setCookie(String cookie) {
        Options options = this.serviceStub._getServiceClient().getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setTimeOutInMilliSeconds(10000L);
    }
}

