/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;

public class ApplicationCache {
    private Cache<String, String[]> cache;

    public ApplicationCache(GitBlitConfiguration configuration) {
        int cacheExpiryTime = Integer.parseInt(configuration.getProperty("appfactory.cache.expiry", "1"));
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)cacheExpiryTime, TimeUnit.MINUTES).build();
    }

    public void put(String user, String[] apps) {
        this.cache.put((Object)user, (Object)apps);
    }

    public String[] get(String user) {
        return (String[])this.cache.getIfPresent((Object)user);
    }
}

