/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.application.mgt.service.ApplicationManagementServiceApplicationManagementExceptionException;
import org.wso2.carbon.appfactory.application.mgt.service.ApplicationManagementServiceStub;
import org.wso2.carbon.appfactory.git.ContextHolder;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.appfactory.git.util.Util;
import org.wso2.carbon.utils.CarbonUtils;

public class ApplicationManagementServiceClient {
    private static final Logger log = LoggerFactory.getLogger(ApplicationManagementServiceClient.class);
    private ApplicationManagementServiceStub serviceStub;
    private GitBlitConfiguration gitBlitConfiguration;
    private ContextHolder holder;

    public ApplicationManagementServiceClient(GitBlitConfiguration configuration) {
        this.gitBlitConfiguration = configuration;
        this.holder = ContextHolder.getHolder(this.gitBlitConfiguration);
        String username = configuration.getProperty("appfactory.admin.username", "admin");
        String password = configuration.getProperty("appfactory.admin.password", "admin");
        try {
            ConfigurationContext context = this.holder.getConfigurationContext();
            this.serviceStub = new ApplicationManagementServiceStub(context, configuration.getProperty("appfactory.url", "https://localhost:9443") + "/services/ApplicationManagementService");
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (ServiceClient)this.serviceStub._getServiceClient());
            this.serviceStub._getServiceClient().getOptions().setProperty("enableREST", (Object)"true");
            Util.setMaxTotalConnection(this.serviceStub._getServiceClient());
        }
        catch (AxisFault e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllApplicationsOfUser(String domainName, String userName) {
        String[] apps = this.holder.getCache().get(userName);
        if (apps != null) {
            return Arrays.asList(apps);
        }
        try {
            apps = this.serviceStub.getAllApplications(domainName, userName);
            if (apps != null) {
                this.holder.getCache().put(userName, apps);
                List<String> list = Arrays.asList(apps);
                return list;
            }
        }
        catch (AxisFault e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ApplicationManagementServiceApplicationManagementExceptionException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                this.serviceStub._getServiceClient().cleanupTransport();
                this.serviceStub._getServiceClient().cleanup();
                this.serviceStub.cleanup();
            }
            catch (AxisFault fault) {}
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUsersOfApplication(String appFactoryApplicationName) {
        try {
            String[] users = this.serviceStub.getUsersOfApplication(appFactoryApplicationName);
            if (users != null) {
                List<String> list = Arrays.asList(users);
                return list;
            }
        }
        catch (RemoteException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ApplicationManagementServiceApplicationManagementExceptionException e) {
            log.error("Error while calling ApplicationManagementService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                this.serviceStub._getServiceClient().cleanupTransport();
                this.serviceStub._getServiceClient().cleanup();
                this.serviceStub.cleanup();
            }
            catch (AxisFault fault) {}
        }
        return Collections.emptyList();
    }
}

