/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.git.ApplicationCache;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.appfactory.git.UserPasswordCache;

public class ContextHolder {
    private static final Logger log = LoggerFactory.getLogger(ContextHolder.class);
    private static ContextHolder holder;
    private ConfigurationContext configurationContext;
    private ApplicationCache cache;
    private UserPasswordCache passwordCache;

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public ApplicationCache getCache() {
        return this.cache;
    }

    public UserPasswordCache getUserPasswordCache() {
        return this.passwordCache;
    }

    public static ContextHolder getHolder(GitBlitConfiguration configuration) {
        if (holder == null) {
            holder = new ContextHolder();
            try {
                log.info("Creating Default Axis2 ConfigurationContext");
                ContextHolder.holder.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            }
            catch (AxisFault fault) {
                log.error("Error occurred while initializing  ConfigurationContext", (Throwable)fault);
            }
            ContextHolder.holder.cache = new ApplicationCache(configuration);
            ContextHolder.holder.passwordCache = new UserPasswordCache(configuration);
        }
        return holder;
    }

    private ContextHolder() {
    }
}

