/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.git.ContextHolder;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.appfactory.git.util.Util;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;
import org.wso2.carbon.utils.CarbonUtils;

public class UserAdminServiceClient {
    private static final Logger log = LoggerFactory.getLogger(UserAdminServiceClient.class);
    private UserAdminStub client;
    private GitBlitConfiguration gitBlitConfiguration;
    private ContextHolder holder;

    public UserAdminServiceClient(GitBlitConfiguration configuration) {
        this.gitBlitConfiguration = configuration;
        this.holder = ContextHolder.getHolder(this.gitBlitConfiguration);
        String username = configuration.getProperty("appfactory.admin.username", "admin");
        String password = configuration.getProperty("appfactory.admin.password", "admin");
        try {
            ConfigurationContext context = this.holder.getConfigurationContext();
            this.client = new UserAdminStub(context, configuration.getProperty("appfactory.url", "https://localhost:9443") + "/services/UserAdmin");
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (ServiceClient)this.client._getServiceClient());
            Util.setMaxTotalConnection(this.client._getServiceClient());
        }
        catch (AxisFault fault) {
            log.error("Error while calling UserAdminService:Error is " + fault.getLocalizedMessage(), (Throwable)fault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllUsers() {
        try {
            String[] users = this.client.listUsers("*", 100);
            if (users != null) {
                List<String> list = Arrays.asList(users);
                return list;
            }
        }
        catch (AxisFault fault) {
            log.error("Error while calling UserAdminService:Error is " + fault.getLocalizedMessage(), (Throwable)fault);
        }
        catch (RemoteException e) {
            log.error("Error while calling UserAdminService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UserAdminUserAdminException e) {
            log.error("Error while calling UserAdminService:Error is " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                this.client._getServiceClient().cleanupTransport();
                this.client._getServiceClient().cleanup();
                this.client.cleanup();
            }
            catch (AxisFault fault) {}
        }
        return Collections.emptyList();
    }
}

