/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.git;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;

public class UserPasswordCache {
    private static final Logger log = LoggerFactory.getLogger(UserPasswordCache.class);
    private Cache<String, byte[]> cache;

    public UserPasswordCache(GitBlitConfiguration configuration) {
        int cacheExpiryTime = Integer.parseInt(configuration.getProperty("appfactory.cache.expiry", "1"));
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)cacheExpiryTime, TimeUnit.MINUTES).build();
    }

    public void put(String user, String password) {
        byte[] pwd;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(password.getBytes());
            pwd = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Specified hashing algorithm is not found ", (Throwable)e);
            return;
        }
        this.cache.put((Object)user, (Object)pwd);
    }

    public byte[] get(String user, String password) {
        return (byte[])this.cache.getIfPresent((Object)user);
    }

    public static byte[] getHashedPassword(String password) {
        byte[] pwd = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(password.getBytes());
            pwd = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Specified hashing algorithm is not found ", (Throwable)e);
        }
        return pwd;
    }
}

