/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.gitblit.oauth.oauth2;

import com.gitblit.Constants;
import com.gitblit.IUserService;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.appfactory.git.AppFactoryAuthenticationClient;
import org.wso2.carbon.appfactory.git.AppFactoryGitBlitUserModel;
import org.wso2.carbon.appfactory.git.AppFactoryRepositoryAuthorizationClient;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.appfactory.git.GitBlitUserModelHolder;
import org.wso2.carbon.appfactory.git.UserAdminServiceClient;
import org.wso2.carbon.appfactory.gitblit.oauth.oauth2.OAuthAuthenticator;

public class AppFactoryGitBlitAuthenticationProvider
extends AuthenticationProvider.UsernamePasswordAuthenticationProvider
implements IUserService {
    private static GitBlitConfiguration configuration;
    private static Map<String, GitBlitUserModelHolder> userModelMap;

    public AppFactoryAuthenticationClient getAppFactoryAuthenticationClient() {
        return new AppFactoryAuthenticationClient(this.getConfiguration());
    }

    public GitBlitConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(GitBlitConfiguration configuration) {
        AppFactoryGitBlitAuthenticationProvider.configuration = configuration;
    }

    public AppFactoryRepositoryAuthorizationClient getRepositoryAuthorizationClient() {
        return new AppFactoryRepositoryAuthorizationClient(this.getConfiguration());
    }

    public UserAdminServiceClient getUserAdminServiceClient() {
        return new UserAdminServiceClient(this.getConfiguration());
    }

    public AppFactoryGitBlitAuthenticationProvider() {
        super("appfactory");
    }

    public void setup() {
        configuration = new GitBlitConfiguration(this.settings);
        try {
            System.setProperty("javax.net.ssl.trustStore", configuration.getProperty("appfactory.truststore", new File(".").getCanonicalPath() + "./client-truststore.jks"));
            System.setProperty("javax.net.ssl.keyStore", configuration.getProperty("appfactory.keystore", new File(".").getCanonicalPath() + "./wso2carbon.jks"));
        }
        catch (IOException e) {
            this.logger.error("Could not find any trust store for communicate with app factory");
        }
        System.setProperty("javax.net.ssl.trustStorePassword", configuration.getProperty("appfactory.truststore.password", "wso2carbon"));
        System.setProperty("javax.net.ssl.keyStorePassword", configuration.getProperty("appfactory.keystore.password", "wso2carbon"));
        this.logger.info("***********App Factory User Service is  initialized ************");
    }

    public UserModel authenticate(String username, char[] password) {
        OAuthAuthenticator oauthAuthenticationService;
        UserModel userModel;
        AppFactoryAuthenticationClient client = this.getAppFactoryAuthenticationClient();
        String cookie = null;
        String passwordStr = new String(password);
        if (this.settings.getBoolean("appfactory.oauth.enable", false) && passwordStr.equals("x-oauth-basic") && (userModel = (oauthAuthenticationService = new OAuthAuthenticator(this.settings)).authenticate(username)) != null) {
            userModelMap.put(userModel.getName(), new GitBlitUserModelHolder(userModel));
            return userModel;
        }
        if (this.authenticateAdmin(username, password) || (cookie = client.authenticate(username, passwordStr)) != null) {
            AppFactoryGitBlitUserModel userModel2 = new AppFactoryGitBlitUserModel(username, this.getConfiguration(), this.getRepositoryAuthorizationClient());
            if (username.equals(this.settings.getString("appfactory.gitblit.admin.username", "admin"))) {
                userModel2.canAdmin = true;
                userModel2.password = passwordStr;
            } else {
                userModel2.canAdmin = false;
                userModel2.cookie = cookie;
                userModel2.password = passwordStr;
            }
            userModelMap.put(username, new GitBlitUserModelHolder(userModel2));
            GitBlitUserModelHolder gitBlitUserModelHolder = new GitBlitUserModelHolder(userModel2);
            return userModel2;
        }
        return null;
    }

    private boolean authenticateAdmin(String username, char[] password) {
        String adminUserName = this.settings.getString("appfactory.gitblit.admin.username", "admin");
        String adminPassword = this.settings.getString("appfactory.gitblit.admin.password", "admin");
        return adminUserName.equals(username) && Arrays.equals(adminPassword.toCharArray(), password);
    }

    public Constants.AccountType getAccountType() {
        return Constants.AccountType.HTPASSWD;
    }

    public boolean supportsCredentialChanges() {
        return false;
    }

    public boolean supportsDisplayNameChanges() {
        return true;
    }

    public boolean supportsEmailAddressChanges() {
        return true;
    }

    public boolean supportsTeamMembershipChanges() {
        return true;
    }

    public static String getAppFactoryApplicationName(String repositoryName) {
        String domainAwareAppId = repositoryName.substring(0, repositoryName.lastIndexOf(".git"));
        String applicationName = domainAwareAppId.substring(domainAwareAppId.lastIndexOf("/") + 1);
        return applicationName;
    }

    public void setup(IRuntimeManager iRuntimeManager) {
    }

    public String getCookie(UserModel model) {
        return null;
    }

    public UserModel getUserModel(char[] chars) {
        String username = new String(chars);
        GitBlitUserModelHolder userModelHolder = userModelMap.get(username);
        if (userModelHolder != null) {
            return userModelHolder.getUserModel();
        }
        return null;
    }

    public UserModel getUserModel(String username) {
        GitBlitUserModelHolder userModelHolder = userModelMap.get(username);
        if (userModelHolder != null) {
            return userModelHolder.getUserModel();
        }
        return null;
    }

    public boolean updateUserModel(UserModel model) {
        return false;
    }

    public boolean updateUserModels(Collection<UserModel> models) {
        return false;
    }

    public boolean updateUserModel(String username, UserModel model) {
        return false;
    }

    public boolean deleteUserModel(UserModel model) {
        return false;
    }

    public boolean deleteUser(String username) {
        return false;
    }

    public List<String> getAllUsernames() {
        return this.getUserAdminServiceClient().getAllUsers();
    }

    public List<UserModel> getAllUsers() {
        return Collections.emptyList();
    }

    public List<String> getAllTeamNames() {
        return Collections.emptyList();
    }

    public List<TeamModel> getAllTeams() {
        return Collections.emptyList();
    }

    public List<String> getTeamNamesForRepositoryRole(String repositoryName) {
        ArrayList<String> appList = new ArrayList<String>();
        appList.add(repositoryName);
        return appList;
    }

    public TeamModel getTeamModel(String teamName) {
        return new TeamModel(teamName);
    }

    public boolean updateTeamModel(TeamModel model) {
        return false;
    }

    public boolean updateTeamModels(Collection<TeamModel> models) {
        return false;
    }

    public boolean updateTeamModel(String teamname, TeamModel model) {
        return false;
    }

    public boolean deleteTeamModel(TeamModel model) {
        return false;
    }

    public boolean deleteTeam(String teamname) {
        return false;
    }

    public List<String> getUsernamesForRepositoryRole(String role) {
        return Collections.emptyList();
    }

    public boolean renameRepositoryRole(String oldRole, String newRole) {
        return false;
    }

    public boolean deleteRepositoryRole(String role) {
        return false;
    }

    static {
        userModelMap = new HashMap<String, GitBlitUserModelHolder>();
    }
}

