/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.gitblit.oauth.oauth2;

import com.gitblit.IStoredSettings;
import com.gitblit.models.UserModel;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.appfactory.git.AppFactoryGitBlitUserModel;
import org.wso2.carbon.appfactory.git.AppFactoryRepositoryAuthorizationClient;
import org.wso2.carbon.appfactory.git.GitBlitConfiguration;
import org.wso2.carbon.identity.oauth2.stub.OAuth2TokenValidationServiceStub;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO_OAuth2AccessToken;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthAuthenticator {
    protected static final String AUTH_HEADER_NAME = "Authorization";
    protected static final String BEARER = "Bearer";
    protected static final String ACCESS_TOKEN = "access_token";
    protected static final String BEARER_TOKEN_TYPE = "bearer";
    private OAuth2TokenValidationServiceStub stub = null;
    private static final Logger logger = LoggerFactory.getLogger(OAuthAuthenticator.class);
    private GitBlitConfiguration configuration;
    private String endPoint = "";
    private IStoredSettings settings;

    public OAuthAuthenticator(IStoredSettings settings) {
        this.settings = settings;
        this.configuration = new GitBlitConfiguration(settings);
        String serverUrl = this.configuration.getProperty("appfactory.is.url", "https://localhost:9444");
        String serviceName = this.configuration.getProperty("appfactory.is.oauth.service", "OAuth2TokenValidationService");
        String adminuser = this.configuration.getProperty("appfactory.admin.username", "admin");
        String adminpass = this.configuration.getProperty("appfactory.admin.password", "admin");
        this.endPoint = serverUrl + "/" + serviceName;
        try {
            this.stub = new OAuth2TokenValidationServiceStub(this.endPoint);
            CarbonUtils.setBasicAccessSecurityHeaders((String)adminuser, (String)adminpass, (boolean)true, (ServiceClient)this.stub._getServiceClient());
        }
        catch (AxisFault e) {
            logger.warn("Stub initialization failed. " + (Object)((Object)e));
        }
    }

    public UserModel authenticate(String accessTokenStr) {
        OAuth2TokenValidationRequestDTO oauthReq = new OAuth2TokenValidationRequestDTO();
        OAuth2TokenValidationRequestDTO_OAuth2AccessToken accessToken = new OAuth2TokenValidationRequestDTO_OAuth2AccessToken();
        accessToken.setIdentifier(accessTokenStr);
        accessToken.setTokenType(BEARER_TOKEN_TYPE);
        oauthReq.setAccessToken(accessToken);
        OAuth2TokenValidationResponseDTO oauthResponse = null;
        try {
            oauthResponse = this.stub.validate(oauthReq);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        String username = oauthResponse.getAuthorizedUser();
        if (MultitenantUtils.getTenantDomain((String)username).equals("carbon.super")) {
            username = MultitenantUtils.getTenantAwareUsername((String)username);
        }
        AppFactoryGitBlitUserModel userModel = new AppFactoryGitBlitUserModel(username, this.configuration, new AppFactoryRepositoryAuthorizationClient(this.configuration));
        return userModel;
    }
}

