/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.configuration.server;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.wso2.appserver.configuration.server.AppServerClassLoading;
import org.wso2.appserver.configuration.server.AppServerSecurity;
import org.wso2.appserver.configuration.server.AppServerSingleSignOn;
import org.wso2.appserver.configuration.server.AppServerStatsPublishing;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="AppServer")
public class ApplicationServerConfiguration {
    @XmlElement(name="ClassLoader")
    private AppServerClassLoading classLoaderEnvironments;
    @XmlElement(name="SAML2SingleSignOn")
    private AppServerSingleSignOn singleSignOnConfiguration;
    @XmlElement(name="StatisticsPublisher")
    private AppServerStatsPublishing statsPublisherConfiguration;
    @XmlElement(name="Security")
    private AppServerSecurity securityConfiguration;

    public AppServerClassLoading getClassLoaderEnvironments() {
        return this.classLoaderEnvironments;
    }

    public void setClassLoaderEnvironments(AppServerClassLoading classLoaderEnvironments) {
        this.classLoaderEnvironments = classLoaderEnvironments;
    }

    public AppServerSingleSignOn getSingleSignOnConfiguration() {
        return this.singleSignOnConfiguration;
    }

    public void setSingleSignOnConfiguration(AppServerSingleSignOn singleSignOnConfiguration) {
        this.singleSignOnConfiguration = singleSignOnConfiguration;
    }

    public AppServerStatsPublishing getStatsPublisherConfiguration() {
        return this.statsPublisherConfiguration;
    }

    public void setStatsPublisherConfiguration(AppServerStatsPublishing statsPublisherConfiguration) {
        this.statsPublisherConfiguration = statsPublisherConfiguration;
    }

    public AppServerSecurity getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(AppServerSecurity securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public void resolveVariables() {
        this.resolveEnvVariables();
        this.resolveSystemProperties();
    }

    private void resolveEnvVariables() {
        StrSubstitutor strSubstitutor = new StrSubstitutor(System.getenv());
        this.classLoaderEnvironments.getEnvironments().getEnvironments().forEach(environment -> environment.setClasspath(strSubstitutor.replace(environment.getClasspath())));
        this.securityConfiguration.getKeystore().setLocation(strSubstitutor.replace(this.securityConfiguration.getKeystore().getLocation()));
        this.securityConfiguration.getTruststore().setLocation(strSubstitutor.replace(this.securityConfiguration.getTruststore().getLocation()));
    }

    private void resolveSystemProperties() {
        this.classLoaderEnvironments.getEnvironments().getEnvironments().forEach(environment -> environment.setClasspath(StrSubstitutor.replaceSystemProperties((Object)environment.getClasspath())));
        this.securityConfiguration.getKeystore().setLocation(StrSubstitutor.replaceSystemProperties((Object)this.securityConfiguration.getKeystore().getLocation()));
        this.securityConfiguration.getTruststore().setLocation(StrSubstitutor.replaceSystemProperties((Object)this.securityConfiguration.getTruststore().getLocation()));
    }
}

