/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.loader;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.wso2.appserver.webapp.loader.WebappClassLoaderContext;

public class AppServerWebappClassLoader
extends WebappClassLoaderBase {
    private static final Log log = LogFactory.getLog(AppServerWebappClassLoader.class);
    private WebappClassLoaderContext webappClassLoaderContext;

    public AppServerWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    public synchronized void setWebappClassLoaderContext(WebappClassLoaderContext classLoaderContext) {
        this.webappClassLoaderContext = classLoaderContext;
        this.webappClassLoaderContext.getProvidedRepositories().forEach(this::addRepository);
    }

    public ClassLoader copyWithoutTransformers() {
        ClassLoader parent = this.getParent();
        AppServerWebappClassLoader result = AccessController.doPrivileged(() -> new AppServerWebappClassLoader(parent));
        super.copyStateWithoutTransformers((WebappClassLoaderBase)result);
        try {
            result.start();
            return result;
        }
        catch (LifecycleException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void addRepository(String repository) {
        try {
            URL url = new URL(repository);
            this.addURL(url);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding repository: " + repository + " to the web app class path"));
            }
        }
        catch (MalformedURLException ex) {
            log.warn((Object)("Repository: " + repository + ", does not exist."), (Throwable)ex);
        }
    }
}

