/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Context;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.wso2.appserver.configuration.context.ClassLoaderConfiguration;
import org.wso2.appserver.configuration.listeners.ContextConfigurationLoader;
import org.wso2.appserver.configuration.listeners.ServerConfigurationLoader;
import org.wso2.appserver.exceptions.ApplicationServerRuntimeException;
import org.wso2.appserver.webapp.loader.AppServerWebappLoader;

public class WebappClassLoaderContext {
    private static Map<String, List<String>> definedEnvironments = new ConcurrentHashMap<String, List<String>>();
    private static final Log log = LogFactory.getLog(AppServerWebappLoader.class);
    private Map<String, List<String>> selectedEnvironments = new ConcurrentHashMap<String, List<String>>();

    public WebappClassLoaderContext(Context context) {
        ContextConfigurationLoader.getContextConfiguration((Context)context).ifPresent(configuration -> {
            ClassLoaderConfiguration classLoaderConfiguration = configuration.getClassLoaderConfiguration();
            if (classLoaderConfiguration != null && classLoaderConfiguration.getEnvironments() != null) {
                List<String> environmentNames = Arrays.asList(classLoaderConfiguration.getEnvironments().split("\\s*,\\s*"));
                environmentNames.forEach(environmentName -> {
                    if (definedEnvironments.containsKey(environmentName)) {
                        this.selectedEnvironments.put((String)environmentName, definedEnvironments.get(environmentName));
                    } else {
                        String message = "Undefined environment: " + environmentName + " in " + context.getPath();
                        log.warn((Object)message);
                    }
                });
            }
        });
    }

    public List<String> getProvidedRepositories() {
        ArrayList<String> repositories = new ArrayList<String>();
        this.selectedEnvironments.entrySet().stream().map(Map.Entry::getValue).forEach(repositories::addAll);
        return repositories;
    }

    private static List<String> generateClasspath(String classPath) throws FileNotFoundException {
        ArrayList<String> urlStr = new ArrayList<String>();
        String realClassPath = StrSubstitutor.replaceSystemProperties((Object)classPath);
        File classPathUrl = new File(realClassPath);
        if (!classPathUrl.exists()) {
            throw new FileNotFoundException("The classpath: " + realClassPath + " does not exist.");
        }
        if (classPathUrl.isFile()) {
            urlStr.add(classPathUrl.toURI().toString());
            return urlStr;
        }
        FileUtils.listFiles((File)classPathUrl, (String[])new String[]{"jar"}, (boolean)false).forEach(file -> urlStr.add(file.toURI().toString()));
        return urlStr;
    }

    static {
        List environments = ServerConfigurationLoader.getServerConfiguration().getClassLoaderEnvironments().getEnvironments().getEnvironments();
        environments.forEach(environment -> {
            if (!definedEnvironments.containsKey(environment.getName())) {
                ArrayList<String> repositories = new ArrayList<String>();
                try {
                    repositories.addAll(WebappClassLoaderContext.generateClasspath(environment.getClasspath()));
                    definedEnvironments.put(environment.getName(), repositories);
                }
                catch (FileNotFoundException ex) {
                    String message = "Environment configuration of: " + environment.getName() + " is wrong.";
                    log.error((Object)message, (Throwable)ex);
                    throw new ApplicationServerRuntimeException(message, (Throwable)ex);
                }
            } else {
                log.warn((Object)("Duplicated environment: " + environment.getName() + ", skipping classpath: " + environment.getClasspath()));
            }
        });
    }
}

