/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.saml;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.apache.catalina.connector.Request;
import org.apache.juli.logging.Log;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.wso2.appserver.configuration.context.WebAppSingleSignOn;
import org.wso2.appserver.configuration.listeners.ServerConfigurationLoader;
import org.wso2.appserver.configuration.server.AppServerSingleSignOn;
import org.wso2.appserver.webapp.security.agent.SSOAgentSessionManager;
import org.wso2.appserver.webapp.security.bean.LoggedInSession;
import org.wso2.appserver.webapp.security.saml.signature.SSOX509Credential;
import org.wso2.appserver.webapp.security.saml.signature.SignatureValidator;
import org.wso2.appserver.webapp.security.saml.signature.X509CredentialImplementation;
import org.wso2.appserver.webapp.security.utils.DataHolder;
import org.wso2.appserver.webapp.security.utils.SSOUtils;
import org.wso2.appserver.webapp.security.utils.exception.SSOException;

public class SAML2SSOManager {
    private AppServerSingleSignOn serverConfiguration = ServerConfigurationLoader.getServerConfiguration().getSingleSignOnConfiguration();
    private WebAppSingleSignOn contextConfiguration;

    public SAML2SSOManager(WebAppSingleSignOn context) throws SSOException {
        this.contextConfiguration = context;
        this.loadCustomSignatureValidatorClass();
        SSOUtils.doBootstrap();
    }

    private void loadCustomSignatureValidatorClass() throws SSOException {
        try {
            if (this.serverConfiguration != null) {
                DataHolder.getInstance().setObject(Class.forName(Optional.ofNullable(this.serverConfiguration.getSignatureValidatorImplClass()).orElse("org.wso2.appserver.webapp.security.saml.signature.SAMLSignatureValidatorImplementation")).newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SSOException("Error loading custom signature validator class", e);
        }
    }

    public String handleAuthenticationRequestForPOSTBinding(Request request) throws SSOException {
        AuthnRequest requestMessage = this.buildAuthnRequest(request);
        if (this.contextConfiguration.isRequestSigningEnabled().booleanValue()) {
            requestMessage = SSOUtils.setSignature((RequestAbstractType)requestMessage, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", new X509CredentialImplementation(SSOX509Credential.getInstance()));
        }
        return this.preparePOSTRequest((RequestAbstractType)requestMessage);
    }

    public String handleAuthenticationRequestForRedirectBinding(Request request) throws SSOException {
        AuthnRequest requestMessage = this.buildAuthnRequest(request);
        return this.prepareRedirectRequest((RequestAbstractType)requestMessage);
    }

    public String handleLogoutRequestForPOSTBinding(Request request) throws SSOException {
        LogoutRequest requestMessage;
        LoggedInSession session = (LoggedInSession)request.getSession(false).getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession");
        if (session != null) {
            requestMessage = this.buildLogoutRequest(session.getSAML2SSO().getSubjectId(), session.getSAML2SSO().getSessionIndex());
            if (this.contextConfiguration.isRequestSigningEnabled().booleanValue()) {
                requestMessage = SSOUtils.setSignature((RequestAbstractType)requestMessage, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", new X509CredentialImplementation(SSOX509Credential.getInstance()));
            }
        } else {
            throw new SSOException("Single-logout (SLO) Request cannot be built, single-sign-on (SSO) session is null");
        }
        return this.preparePOSTRequest((RequestAbstractType)requestMessage);
    }

    public String handleLogoutRequestForRedirectBinding(Request request) throws SSOException {
        LoggedInSession session = (LoggedInSession)request.getSession(false).getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession");
        if (session == null) {
            throw new SSOException("Single Logout Request can not be built, single-sign-on session is null");
        }
        LogoutRequest requestMessage = this.buildLogoutRequest(session.getSAML2SSO().getSubjectId(), session.getSAML2SSO().getSessionIndex());
        return this.prepareRedirectRequest((RequestAbstractType)requestMessage);
    }

    private String preparePOSTRequest(RequestAbstractType rawRequestMessage) throws SSOException {
        String encodedRequestMessage = SSOUtils.encodeRequestMessage(rawRequestMessage, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        parameters.put("SAMLRequest", new String[]{encodedRequestMessage});
        Map<String, String[]> queryParams = SSOUtils.getSplitQueryParameters(this.contextConfiguration.getOptionalParams());
        queryParams.entrySet().stream().forEach(filteredEntry -> filteredEntry.setValue((String[])Stream.of((Object[])filteredEntry.getValue()).map(value -> {
            try {
                return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }).toArray()));
        if (!queryParams.isEmpty()) {
            parameters.putAll(queryParams);
        }
        StringBuilder htmlParameters = new StringBuilder();
        parameters.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null && ((String[])entry.getValue()).length > 0).forEach(filteredEntry -> Stream.of((Object[])filteredEntry.getValue()).forEach(parameter -> htmlParameters.append("<input type='hidden' name='").append((String)filteredEntry.getKey()).append("' value='").append((String)parameter).append("'>\n")));
        return "<html>\n<body>\n<p>You are now redirected back to " + this.serverConfiguration.getIdpURL() + " \n" + "If the redirection fails, please click the post button.</p>\n" + "<form method='post' action='" + this.serverConfiguration.getIdpURL() + "'>\n" + "<p>\n" + htmlParameters.toString() + "<button type='submit'>POST</button>\n" + "</p>\n" + "</form>\n" + "<script type='text/javascript'>\n" + "document.forms[0].submit();\n" + "</script>\n" + "</body>\n" + "</html>";
    }

    private String prepareRedirectRequest(RequestAbstractType rawRequestMessage) throws SSOException {
        String encodedRequestMessage = SSOUtils.encodeRequestMessage(rawRequestMessage, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        StringBuilder httpQueryString = new StringBuilder("SAMLRequest=" + encodedRequestMessage);
        Map<String, String[]> queryParams = SSOUtils.getSplitQueryParameters(this.contextConfiguration.getOptionalParams());
        if (!queryParams.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            queryParams.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null && ((String[])entry.getValue()).length > 0).forEach(filteredEntry -> Stream.of((Object[])filteredEntry.getValue()).forEach(parameterValue -> {
                try {
                    builder.append("&").append((String)filteredEntry.getKey()).append("=").append(URLEncoder.encode(parameterValue, StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }));
            httpQueryString.append((CharSequence)builder);
        }
        if (this.contextConfiguration.isRequestSigningEnabled().booleanValue()) {
            SSOUtils.addDeflateSignatureToHTTPQueryString(httpQueryString, new X509CredentialImplementation(SSOX509Credential.getInstance()));
        }
        String idpUrl = this.serverConfiguration.getIdpURL().contains("?") ? this.serverConfiguration.getIdpURL().concat("&").concat(httpQueryString.toString()) : this.serverConfiguration.getIdpURL().concat("?").concat(httpQueryString.toString());
        return idpUrl;
    }

    private AuthnRequest buildAuthnRequest(Request request) {
        Issuer issuer = new IssuerBuilder().buildObject();
        if (this.contextConfiguration.getIssuerId() == null) {
            String issuerID = SSOUtils.generateIssuerID(request.getContextPath(), request.getHost().getAppBase()).orElse("");
            this.contextConfiguration.setIssuerId(issuerID);
        }
        issuer.setValue(this.contextConfiguration.getIssuerId());
        NameIDPolicy nameIdPolicy = new NameIDPolicyBuilder().buildObject();
        nameIdPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameIdPolicy.setSPNameQualifier("Issuer");
        nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
        AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
        authnRequest.setID(SSOUtils.createID());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setForceAuthn(Optional.ofNullable((Boolean)request.getAttribute("IsForceAuthn")).orElse(false));
        authnRequest.setIsPassive(Optional.ofNullable((Boolean)request.getAttribute("IsPassiveAuthn")).orElse(false));
        authnRequest.setProtocolBinding(this.contextConfiguration.getHttpBinding());
        if (this.contextConfiguration.getConsumerURL() == null) {
            String acsBase = Optional.ofNullable(this.serverConfiguration.getACSBase()).orElse(SSOUtils.constructApplicationServerURL(request).orElse(""));
            String consumerURLPostfix = Optional.ofNullable(this.contextConfiguration.getConsumerURLPostfix()).orElse("acs");
            String consumerURL = SSOUtils.generateConsumerURL(request.getContextPath(), acsBase, consumerURLPostfix).orElse("");
            this.contextConfiguration.setConsumerURL(consumerURL);
        }
        authnRequest.setAssertionConsumerServiceURL(this.contextConfiguration.getConsumerURL());
        authnRequest.setIssuer(issuer);
        authnRequest.setNameIDPolicy(nameIdPolicy);
        authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        authnRequest.setDestination(this.serverConfiguration.getIdpURL());
        Optional.ofNullable(request.getAttribute("Extensions")).ifPresent(extensions -> authnRequest.setExtensions((Extensions)extensions));
        return authnRequest;
    }

    private LogoutRequest buildLogoutRequest(String user, String sessionIndex) {
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
        DateTime issueInstant = new DateTime();
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(this.contextConfiguration.getIssuerId());
        NameID nameId = new NameIDBuilder().buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        nameId.setValue(user);
        SessionIndex sessionIndexElement = new SessionIndexBuilder().buildObject();
        sessionIndexElement.setSessionIndex(sessionIndex);
        logoutRequest.setID(SSOUtils.createID());
        logoutRequest.setIssueInstant(issueInstant);
        logoutRequest.setDestination(this.serverConfiguration.getIdpURL());
        logoutRequest.setNotOnOrAfter(new DateTime(issueInstant.getMillis() + 300000L));
        logoutRequest.setIssuer(issuer);
        logoutRequest.setNameID(nameId);
        logoutRequest.getSessionIndexes().add(sessionIndexElement);
        logoutRequest.setReason("Single Logout");
        return logoutRequest;
    }

    public void processResponse(Request request) throws SSOException {
        String saml2SSOResponse = request.getParameter("SAMLResponse");
        if (saml2SSOResponse != null) {
            String decodedResponse = new String(Base64Support.decode((String)saml2SSOResponse), StandardCharsets.UTF_8);
            Optional<XMLObject> samlObject = SSOUtils.unmarshall(decodedResponse);
            if (samlObject.isPresent()) {
                if (samlObject.get() instanceof LogoutResponse) {
                    this.performSingleLogout(request);
                } else {
                    this.processSingleSignInResponse(request);
                }
            }
        } else {
            throw new SSOException("Invalid SAML 2.0 Response, SAML Response cannot be null");
        }
    }

    private void processSingleSignInResponse(Request request) throws SSOException {
        LoggedInSession session = new LoggedInSession();
        session.setSAML2SSO(new LoggedInSession.SAML2SSO());
        String saml2ResponseString = new String(Base64Support.decode((String)request.getParameter("SAMLResponse")), StandardCharsets.UTF_8);
        Optional<XMLObject> xmlObject = SSOUtils.unmarshall(saml2ResponseString);
        if (!xmlObject.isPresent()) {
            return;
        }
        Response saml2Response = (Response)xmlObject.get();
        session.getSAML2SSO().setResponseString(saml2ResponseString);
        session.getSAML2SSO().setSAMLResponse(saml2Response);
        Assertion assertion = null;
        if (this.contextConfiguration.isAssertionEncryptionEnabled().booleanValue()) {
            List encryptedAssertions = saml2Response.getEncryptedAssertions();
            if (encryptedAssertions != null && !encryptedAssertions.isEmpty()) {
                EncryptedAssertion encryptedAssertion = encryptedAssertions.stream().findFirst().orElse(null);
                try {
                    assertion = SSOUtils.decryptAssertion(SSOX509Credential.getInstance(), encryptedAssertion);
                }
                catch (Exception e) {
                    throw new SSOException("Unable to decrypt the SAML 2.0 Assertion");
                }
            }
        } else {
            List assertions = saml2Response.getAssertions();
            if (assertions != null && !assertions.isEmpty()) {
                assertion = assertions.stream().findFirst().orElse(null);
            }
        }
        if (assertion == null) {
            if (this.isNoPassive(saml2Response)) {
                Log containerLog = request.getHost().getLogger();
                if (containerLog.isDebugEnabled()) {
                    containerLog.debug((Object)"Cannot authenticate in passive mode");
                }
                return;
            }
            throw new SSOException("SAML 2.0 Assertion not found in the Response");
        }
        String idPEntityIdValue = assertion.getIssuer().getValue();
        if (idPEntityIdValue == null || idPEntityIdValue.isEmpty()) {
            throw new SSOException("SAML 2.0 Response does not contain an Issuer value");
        }
        if (!idPEntityIdValue.equals(this.serverConfiguration.getIdpEntityId())) {
            throw new SSOException("SAML 2.0 Response Issuer verification failed");
        }
        session.getSAML2SSO().setAssertion(assertion);
        String subject = null;
        if (assertion.getSubject() != null && assertion.getSubject().getNameID() != null) {
            subject = assertion.getSubject().getNameID().getValue();
        }
        if (subject == null) {
            throw new SSOException("SAML 2.0 Response does not contain the name of the subject");
        }
        session.getSAML2SSO().setSubjectId(subject);
        request.getSession().setAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession", (Object)session);
        this.validateAudienceRestriction(assertion);
        this.validateSignature(saml2Response, assertion);
        session.getSAML2SSO().setAssertionString(SSOUtils.marshall((XMLObject)assertion));
        ((LoggedInSession)request.getSession().getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession")).getSAML2SSO().setSubjectAttributes(SSOUtils.getAssertionStatements(assertion));
        if (this.contextConfiguration.isSLOEnabled().booleanValue()) {
            Optional authnStatement = assertion.getAuthnStatements().stream().findFirst();
            String sessionId = null;
            if (authnStatement.isPresent()) {
                sessionId = ((AuthnStatement)authnStatement.get()).getSessionIndex();
            }
            if (sessionId == null) {
                throw new SSOException("Single Logout is enabled but IdP Session ID not found in SAML 2.0 Assertion");
            }
            ((LoggedInSession)request.getSession().getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession")).getSAML2SSO().setSessionIndex(sessionId);
            SSOAgentSessionManager.addAuthenticatedSession(request.getSession(false));
        }
    }

    private void performSingleLogout(Request request) throws SSOException {
        Optional<XMLObject> xmlObject;
        XMLObject saml2Object = null;
        if (request.getParameter("SAMLRequest") != null && (xmlObject = SSOUtils.unmarshall(new String(Base64Support.decode((String)request.getParameter("SAMLRequest")), StandardCharsets.UTF_8))).isPresent()) {
            saml2Object = xmlObject.get();
        }
        if (saml2Object == null && (xmlObject = SSOUtils.unmarshall(new String(Base64Support.decode((String)request.getParameter("SAMLResponse")), StandardCharsets.UTF_8))).isPresent()) {
            saml2Object = xmlObject.get();
        }
        if (saml2Object instanceof LogoutResponse) {
            Optional.ofNullable(request.getSession(false)).ifPresent(session -> {
                Set<HttpSession> sessions = SSOAgentSessionManager.getAllInvalidatableSessions(session);
                sessions.stream().forEach(httpSession -> {
                    block2: {
                        try {
                            httpSession.invalidate();
                        }
                        catch (IllegalStateException ignore) {
                            Log containerLog = request.getHost().getLogger();
                            if (!containerLog.isDebugEnabled()) break block2;
                            containerLog.debug((Object)"Ignoring exception : ", (Throwable)ignore);
                        }
                    }
                });
            });
        } else if (saml2Object instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)saml2Object;
            logoutRequest.getSessionIndexes().stream().findFirst().ifPresent(index -> SSOAgentSessionManager.getAllInvalidatableSessions(index.getSessionIndex()).stream().forEach(HttpSession::invalidate));
        } else {
            throw new SSOException("Invalid SAML 2.0 Single Logout Request/Response.");
        }
    }

    private boolean isNoPassive(Response response) {
        return response.getStatus() != null && response.getStatus().getStatusCode() != null && response.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Responder") && response.getStatus().getStatusCode().getStatusCode() != null && response.getStatus().getStatusCode().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:NoPassive");
    }

    private void validateAudienceRestriction(Assertion assertion) throws SSOException {
        if (assertion == null) {
            return;
        }
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            throw new SSOException("SAML 2.0 Response doesn't contain Conditions");
        }
        List audienceRestrictions = conditions.getAudienceRestrictions();
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) {
            throw new SSOException("SAML 2.0 Response doesn't contain AudienceRestrictions");
        }
        Stream<AudienceRestriction> audienceExistingStream = audienceRestrictions.stream().filter(audienceRestriction -> audienceRestriction.getAudiences() != null && !audienceRestriction.getAudiences().isEmpty() && audienceRestriction.getAudiences().stream().filter(audience -> this.contextConfiguration.getIssuerId().equals(audience.getAudienceURI())).count() > 0L);
        if (audienceExistingStream.count() == 0L) {
            throw new SSOException("SAML 2.0 Assertion Audience Restriction validation failed");
        }
    }

    private void validateSignature(Response response, Assertion assertion) throws SSOException {
        if (DataHolder.getInstance().getObject() != null) {
            SignatureValidator signatureValidatorUtility = (SignatureValidator)DataHolder.getInstance().getObject();
            signatureValidatorUtility.validateSignature(response, assertion, this.contextConfiguration.isResponseSigningEnabled(), this.contextConfiguration.isAssertionSigningEnabled());
        } else {
            SSOX509Credential ssoX509Credential = SSOX509Credential.getInstance();
            if (this.contextConfiguration.isResponseSigningEnabled().booleanValue()) {
                if (response.getSignature() == null) {
                    throw new SSOException("SAML 2.0 Response signing is enabled, but signature element not found in SAML 2.0 Response element");
                }
                try {
                    org.opensaml.xmlsec.signature.support.SignatureValidator.validate((Signature)response.getSignature(), (Credential)new X509CredentialImplementation(ssoX509Credential.getEntityCertificate()));
                }
                catch (SignatureException e) {
                    throw new SSOException("Signature validation failed for SAML 2.0 Response", e);
                }
            }
            if (this.contextConfiguration.isAssertionSigningEnabled().booleanValue()) {
                if (assertion.getSignature() == null) {
                    throw new SSOException("SAML 2.0 Assertion signing is enabled, but signature element not found in SAML 2.0 Assertion element");
                }
                try {
                    org.opensaml.xmlsec.signature.support.SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)new X509CredentialImplementation(ssoX509Credential.getEntityCertificate()));
                }
                catch (SignatureException e) {
                    throw new SSOException("Signature validation failed for SAML 2.0 Assertion", e);
                }
            }
        }
    }
}

