/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.saml.signature;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.wso2.appserver.configuration.listeners.ServerConfigurationLoader;
import org.wso2.appserver.configuration.server.AppServerSecurity;
import org.wso2.appserver.configuration.server.ApplicationServerConfiguration;
import org.wso2.appserver.webapp.security.utils.SSOUtils;
import org.wso2.appserver.webapp.security.utils.exception.SSOException;

public class SSOX509Credential {
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private X509Certificate entityCertificate;
    private String idpCertificateAlias;
    private static SSOX509Credential ssoX509Credential;

    private SSOX509Credential(ApplicationServerConfiguration serverConfiguration) throws SSOException {
        this.idpCertificateAlias = serverConfiguration.getSingleSignOnConfiguration().getIdpCertificateAlias();
        this.readX509Credentials(serverConfiguration.getSecurityConfiguration());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate getEntityCertificate() {
        return this.entityCertificate;
    }

    public static synchronized SSOX509Credential getInstance() throws SSOException {
        if (ssoX509Credential == null) {
            ssoX509Credential = new SSOX509Credential(ServerConfigurationLoader.getServerConfiguration());
        }
        return ssoX509Credential;
    }

    private void readX509Credentials(AppServerSecurity securityConfiguration) throws SSOException {
        Optional generatedKeyStore = SSOUtils.generateKeyStore();
        if (generatedKeyStore.isPresent()) {
            KeyStore keyStore = (KeyStore)generatedKeyStore.get();
            try {
                if (this.idpCertificateAlias != null) {
                    this.entityCertificate = (X509Certificate)keyStore.getCertificate(this.idpCertificateAlias);
                }
            }
            catch (KeyStoreException e) {
                throw new SSOException("Error occurred while retrieving public certificate with certificateAlias " + this.idpCertificateAlias, e);
            }
            try {
                if (securityConfiguration != null && securityConfiguration.getKeystore() != null) {
                    String privateKeyAlias = securityConfiguration.getKeystore().getKeyAlias();
                    String privateKeyPassword = securityConfiguration.getKeystore().getKeyPassword();
                    if (privateKeyAlias != null && privateKeyPassword != null) {
                        this.privateKey = (PrivateKey)keyStore.getKey(privateKeyAlias, privateKeyPassword.toCharArray());
                    }
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new SSOException("Error occurred while retrieving the private key", e);
            }
            if (this.entityCertificate != null) {
                this.publicKey = this.entityCertificate.getPublicKey();
            }
        }
    }
}

