/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.catalina.Engine;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.Base64;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.appserver.webapp.security.saml.signature.SSOX509Credential;
import org.wso2.appserver.webapp.security.saml.signature.X509CredentialImplementation;
import org.wso2.appserver.webapp.security.utils.XMLEntityResolver;
import org.wso2.appserver.webapp.security.utils.exception.SSOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class SSOUtils {
    private static boolean isBootstrapped = false;

    private SSOUtils() {
    }

    public static String createID() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        char[] characterMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
        char[] characters = new char[40];
        IntStream.range(0, bytes.length).forEach(index -> {
            int left = bytes[index] >> 4 & 0xF;
            int right = bytes[index] & 0xF;
            cArray[index * 2] = characterMapping[left];
            cArray[index * 2 + 1] = characterMapping[right];
        });
        return String.valueOf(characters);
    }

    public static Optional<String> constructApplicationServerURL(Request request) {
        if (request == null) {
            return Optional.empty();
        }
        String sslConnectorScheme = "https";
        StringBuilder appServerURL = new StringBuilder(sslConnectorScheme + "://");
        String requestHost = request.getHost().getName();
        Optional<Connector> sslConnector = Arrays.stream(((Engine)request.getHost().getParent()).getService().findConnectors()).filter(connector -> connector.getScheme().equals(sslConnectorScheme)).findFirst();
        if (sslConnector.isPresent()) {
            return Optional.of(appServerURL.append(requestHost).append(":").append(sslConnector.get().getPort()).toString());
        }
        return Optional.empty();
    }

    public static Map<String, String[]> getSplitQueryParameters(String queryParameterString) {
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        if (!StringUtils.isBlank((CharSequence)queryParameterString)) {
            HashMap queryParameterMap = new HashMap();
            Stream.of(queryParameterString.split("&")).map(queryParameter -> queryParameter.split("=")).forEach(splitParameters -> {
                if (((String[])splitParameters).length == 2) {
                    if (queryParameterMap.get(splitParameters[0]) != null) {
                        ((List)queryParameterMap.get(splitParameters[0])).add(splitParameters[1]);
                    } else {
                        ArrayList<String> newList = new ArrayList<String>();
                        newList.add(splitParameters[1]);
                        queryParameterMap.put(splitParameters[0], newList);
                    }
                }
            });
            queryParameterMap.entrySet().stream().forEach(entry -> {
                String[] values = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
                queryParameters.put((String)entry.getKey(), values);
            });
        }
        return queryParameters;
    }

    public static Map<String, Object> generateRelayState(Request request) {
        HashMap<String, Object> relayStateContent = new HashMap<String, Object>();
        Optional.ofNullable(request).ifPresent(requestObject -> {
            relayStateContent.put("RequestURL", requestObject.getRequestURI());
            relayStateContent.put("RequestQueryString", requestObject.getQueryString());
            relayStateContent.put("RequestParams", requestObject.getParameterMap());
        });
        Optional.ofNullable(request.getAttribute("RelayState")).ifPresent(content -> ((Map)content).forEach(relayStateContent::put));
        return relayStateContent;
    }

    public static Optional<String> generateIssuerID(String contextPath, String hostAppBase) {
        if (contextPath != null) {
            String issuerId = contextPath.replaceFirst("/" + hostAppBase, "").replace("/", "_");
            if (issuerId.startsWith("_")) {
                issuerId = issuerId.substring(1);
            }
            return Optional.of(issuerId);
        }
        return Optional.empty();
    }

    public static Optional<String> generateConsumerURL(String contextPath, String acsBase, String acsPostfix) {
        if (contextPath != null && acsBase != null && acsPostfix != null) {
            return Optional.of(acsBase + contextPath + "/" + acsPostfix);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional generateKeyStore() throws SSOException {
        String keystorePathString = System.getProperty("javax.net.ssl.keyStore");
        String keystorePasswordString = System.getProperty("javax.net.ssl.keyStorePassword");
        if (keystorePasswordString == null) return Optional.empty();
        if (keystorePathString == null) {
            return Optional.empty();
        }
        Path keyStorePath = Paths.get(URI.create(keystorePathString).getPath(), new String[0]);
        if (!Files.exists(keyStorePath, new LinkOption[0])) throw new SSOException("File path specified for the keystore does not exist");
        try (InputStream keystoreInputStream = Files.newInputStream(keyStorePath, new OpenOption[0]);){
            KeyStore keyStore = KeyStore.getInstance(System.getProperty("javax.net.ssl.keyStoreType"));
            keyStore.load(keystoreInputStream, keystorePasswordString.toCharArray());
            Optional<KeyStore> optional = Optional.of(keyStore);
            return optional;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SSOException("Error while loading the key store", e);
        }
    }

    public static void sendCharacterData(HttpServletResponse response, String htmlPayload) throws SSOException {
        try {
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write(htmlPayload);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new SSOException("Error occurred while writing to HttpServletResponse", e);
        }
    }

    public static void doBootstrap() throws SSOException {
        try {
            if (!isBootstrapped) {
                InitializationService.initialize();
                isBootstrapped = true;
            }
        }
        catch (InitializationException e) {
            throw new SSOException("Error in bootstrapping the OpenSAML library", e);
        }
    }

    public static RequestAbstractType setSignature(RequestAbstractType request, String signatureAlgorithm, X509Credential credential) throws SSOException {
        try {
            org.opensaml.xmlsec.signature.Signature signature = SSOUtils.setSignatureRaw(signatureAlgorithm, credential);
            request.setSignature(signature);
            ArrayList<org.opensaml.xmlsec.signature.Signature> signatureList = new ArrayList<org.opensaml.xmlsec.signature.Signature>();
            signatureList.add(signature);
            Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)request);
            if (marshaller != null) {
                marshaller.marshall((XMLObject)request);
            }
            Init.init();
            Signer.signObjects(signatureList);
            return request;
        }
        catch (MarshallingException | SignatureException e) {
            throw new SSOException("Error while signing the SAML 2.0 Request message", e);
        }
    }

    private static org.opensaml.xmlsec.signature.Signature setSignatureRaw(String signatureAlgorithm, X509Credential credential) throws SSOException {
        org.opensaml.xmlsec.signature.Signature signature = (org.opensaml.xmlsec.signature.Signature)SSOUtils.buildXMLObject(org.opensaml.xmlsec.signature.Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)credential);
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            KeyInfo keyInfo = (KeyInfo)SSOUtils.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)SSOUtils.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)SSOUtils.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encode((byte[])credential.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
            return signature;
        }
        catch (CertificateEncodingException e) {
            throw new SSOException("Error getting certificate", e);
        }
    }

    private static XMLObject buildXMLObject(QName objectQualifiedName) throws SSOException {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(objectQualifiedName);
        if (builder == null) {
            throw new SSOException("Unable to retrieve builder for object QName " + objectQualifiedName);
        }
        return builder.buildObject(objectQualifiedName.getNamespaceURI(), objectQualifiedName.getLocalPart(), objectQualifiedName.getPrefix());
    }

    public static String encodeRequestMessage(RequestAbstractType requestMessage, String binding) throws SSOException {
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)requestMessage);
        Element authDOM = null;
        try {
            if (marshaller != null) {
                authDOM = marshaller.marshall((XMLObject)requestMessage);
            }
        }
        catch (MarshallingException e) {
            throw new SSOException("Error occurred while encoding SAML 2.0 Request, failed to marshall the SAML 2.0. Request element XMLObject to its corresponding W3C DOM element", e);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (authDOM != null) {
            SerializeSupport.writeNode((Node)authDOM, (OutputStream)outputStream);
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(binding)) {
            Deflater deflater = new Deflater(8, true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);){
                deflaterOutputStream.write(outputStream.toByteArray());
            }
            catch (IOException e) {
                throw new SSOException("Error occurred while deflate encoding SAML 2.0 request", e);
            }
            String encodedRequestMessage = Base64Support.encode((byte[])byteArrayOutputStream.toByteArray(), (boolean)false);
            try {
                return URLEncoder.encode(encodedRequestMessage, StandardCharsets.UTF_8.name()).trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new SSOException("Error occurred while encoding SAML 2.0 request", e);
            }
        }
        return Base64Support.encode((byte[])outputStream.toByteArray(), (boolean)false);
    }

    public static String marshall(XMLObject xmlObject) throws SSOException {
        try {
            Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(xmlObject);
            Element element = null;
            if (marshaller != null) {
                element = marshaller.marshall(xmlObject);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS implementation = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = implementation.createLSSerializer();
            LSOutput output = implementation.createLSOutput();
            output.setByteStream(byteArrayOutputStream);
            writer.write(element, output);
            return new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MarshallingException e) {
            throw new SSOException("Error in marshalling SAML 2.0 Assertion", e);
        }
    }

    public static Optional<XMLObject> unmarshall(String xmlString) throws SSOException {
        try {
            DocumentBuilder docBuilder = SSOUtils.getDocumentBuilder(false, true, new XMLEntityResolver());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8));
            Document document = docBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(element);
            if (unmarshaller == null) {
                return Optional.empty();
            }
            return Optional.of(unmarshaller.unmarshall(element));
        }
        catch (IOException | UnmarshallingException | SAXException e) {
            throw new SSOException("Error in unmarshalling the XML string representation", e);
        }
    }

    public static Assertion decryptAssertion(SSOX509Credential ssoAgentX509Credential, EncryptedAssertion encryptedAssertion) throws SSOException {
        try {
            StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver((Credential)new X509CredentialImplementation(ssoAgentX509Credential));
            KeyInfo keyInfo = encryptedAssertion.getEncryptedData().getKeyInfo();
            Optional<Object> key = Optional.empty();
            if (keyInfo != null) {
                key = keyInfo.getEncryptedKeys().stream().findFirst();
            }
            EncryptedKey encryptedKey = null;
            if (key.isPresent()) {
                encryptedKey = (EncryptedKey)key.get();
            }
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyResolver, null);
            SecretKey decrypterKey = null;
            if (encryptedKey != null) {
                String algorithm;
                EncryptionMethod encryptionMethod = encryptedAssertion.getEncryptedData().getEncryptionMethod();
                if (encryptionMethod != null && (algorithm = encryptionMethod.getAlgorithm()) != null) {
                    decrypterKey = (SecretKey)decrypter.decryptKey(encryptedKey, algorithm);
                }
                BasicCredential shared = SSOUtils.getSimpleCredential(decrypterKey);
                decrypter = new Decrypter((KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver((Credential)shared), null, null);
                decrypter.setRootInNewDocument(true);
            }
            return decrypter.decrypt(encryptedAssertion);
        }
        catch (DecryptionException e) {
            throw new SSOException("Decrypted assertion error", e);
        }
    }

    private static BasicCredential getSimpleCredential(SecretKey secretKey) {
        if (secretKey == null) {
            throw new IllegalArgumentException("A secret key is required");
        }
        return new BasicCredential(secretKey);
    }

    public static Map<String, String> getAssertionStatements(Assertion assertion) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (assertion != null && assertion.getAttributeStatements() != null) {
            Stream attributeStatements = assertion.getAttributeStatements().stream();
            attributeStatements.forEach(attributeStatement -> attributeStatement.getAttributes().stream().forEach(attribute -> {
                Optional value = attribute.getAttributeValues().stream().findFirst();
                if (value.isPresent()) {
                    Optional.ofNullable(((XMLObject)value.get()).getDOM()).ifPresent(dom -> {
                        String attributeValue = dom.getTextContent();
                        results.put(attribute.getName(), attributeValue);
                    });
                }
            }));
        }
        return results;
    }

    public static void addDeflateSignatureToHTTPQueryString(StringBuilder httpQueryString, X509Credential credential) throws SSOException {
        try {
            httpQueryString.append("&SigAlg=").append(URLEncoder.encode("http://www.w3.org/2000/09/xmldsig#rsa-sha1", StandardCharsets.UTF_8.name()).trim());
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(credential.getPrivateKey());
            signature.update(httpQueryString.toString().getBytes(StandardCharsets.UTF_8));
            byte[] signatureByteArray = signature.sign();
            String signatureBase64EncodedString = Base64Support.encode((byte[])signatureByteArray, (boolean)false);
            httpQueryString.append("&Signature=").append(URLEncoder.encode(signatureBase64EncodedString, StandardCharsets.UTF_8.name()).trim());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | java.security.SignatureException e) {
            throw new SSOException("Error applying SAML 2.0 Redirect Binding signature", e);
        }
    }

    private static DocumentBuilder getDocumentBuilder(boolean expandEntityReferences, boolean namespaceAware, EntityResolver entityResolver) throws SSOException {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (!expandEntityReferences) {
            documentBuilderFactory.setExpandEntityReferences(false);
        }
        if (namespaceAware) {
            documentBuilderFactory.setNamespaceAware(true);
        }
        try {
            docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SSOException("Error when generating the new DocumentBuilder", e);
        }
        Optional.ofNullable(entityResolver).ifPresent(docBuilder::setEntityResolver);
        return docBuilder;
    }
}

