/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.agent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.wso2.appserver.webapp.security.bean.LoggedInSession;

public class SSOAgentSessionManager {
    private static final Map<String, Set<HttpSession>> ssoSessionsMap = new HashMap<String, Set<HttpSession>>();

    private SSOAgentSessionManager() {
    }

    public static void addAuthenticatedSession(HttpSession session) {
        String sessionIndex = ((LoggedInSession)session.getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession")).getSAML2SSO().getSessionIndex();
        if (ssoSessionsMap.get(sessionIndex) != null) {
            ssoSessionsMap.get(sessionIndex).add(session);
        } else {
            HashSet<HttpSession> sessions = new HashSet<HttpSession>();
            sessions.add(session);
            ssoSessionsMap.put(sessionIndex, sessions);
        }
    }

    public static Set<HttpSession> getAllInvalidatableSessions(HttpSession session) {
        String sessionIndex;
        LoggedInSession sessionBean = (LoggedInSession)session.getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession");
        Set<Object> sessions = new HashSet();
        if (sessionBean != null && sessionBean.getSAML2SSO() != null && (sessionIndex = sessionBean.getSAML2SSO().getSessionIndex()) != null) {
            sessions = ssoSessionsMap.remove(sessionIndex);
        }
        sessions = Optional.ofNullable(sessions).orElse(new HashSet());
        return sessions;
    }

    public static Set<HttpSession> getAllInvalidatableSessions(String sessionIndex) {
        Set sessions = ssoSessionsMap.remove(sessionIndex);
        sessions = Optional.ofNullable(sessions).orElse(new HashSet());
        return sessions;
    }
}

