/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.agent;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.wso2.appserver.configuration.context.WebAppSingleSignOn;

public class SSORequestResolver {
    private WebAppSingleSignOn ssoConfiguration;
    private HttpServletRequest request;

    public SSORequestResolver(HttpServletRequest request, WebAppSingleSignOn ssoConfiguration) {
        this.ssoConfiguration = ssoConfiguration;
        this.request = request;
    }

    public boolean isURLToSkip() {
        return this.ssoConfiguration != null && this.request != null && this.ssoConfiguration.getSkipURIs() != null && ((List)Optional.ofNullable(this.ssoConfiguration.getSkipURIs().getSkipURIs()).orElse(new ArrayList())).contains(this.request.getRequestURI());
    }

    public boolean isHttpPOSTBinding() {
        if (this.ssoConfiguration == null) {
            return false;
        }
        String httpBindingString = Optional.ofNullable(this.ssoConfiguration.getHttpBinding()).orElse("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        return httpBindingString != null && "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(httpBindingString);
    }

    public boolean isSAML2SSOResponse() {
        return this.request != null && this.request.getParameter("SAMLResponse") != null;
    }

    public boolean isSLOURL() {
        return this.ssoConfiguration != null && this.request != null && this.ssoConfiguration.isSLOEnabled() != false && this.request.getRequestURI().endsWith(Optional.ofNullable(this.ssoConfiguration.getSLOURLPostfix()).orElse("logout"));
    }
}

