/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.saml;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.wso2.appserver.configuration.context.AppServerWebAppConfiguration;
import org.wso2.appserver.configuration.context.WebAppSingleSignOn;
import org.wso2.appserver.configuration.listeners.ContextConfigurationLoader;
import org.wso2.appserver.webapp.security.agent.SSORequestResolver;
import org.wso2.appserver.webapp.security.saml.SAML2SSOManager;
import org.wso2.appserver.webapp.security.utils.SSOUtils;
import org.wso2.appserver.webapp.security.utils.exception.SSOException;

public class SAML2SSOValve
extends SingleSignOn {
    private WebAppSingleSignOn contextConfiguration;
    private SSORequestResolver requestResolver;

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.containerLog.debug((Object)("Invoking SAML 2.0 single-sign-on valve. Request URI : " + request.getRequestURI()));
        Optional contextConfiguration = ContextConfigurationLoader.getContextConfiguration((Context)request.getContext());
        if (contextConfiguration.isPresent()) {
            this.contextConfiguration = ((AppServerWebAppConfiguration)contextConfiguration.get()).getSingleSignOnConfiguration();
            if (this.contextConfiguration == null) {
                if (this.containerLog.isDebugEnabled()) {
                    this.containerLog.debug((Object)("No context level, single-sign-on configuration found for " + request.getContext() + ", skipping SAML 2.0 based single-sign-on/single-logout..."));
                }
                this.getNext().invoke(request, response);
                return;
            }
        } else {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("No context level configuration found for " + request.getContext() + ", skipping SAML 2.0 based single-sign-on/single-logout..."));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (!Optional.ofNullable(this.contextConfiguration.isSSOEnabled()).orElse(false).booleanValue()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("SAML 2.0 single-sign-on not enabled in web app " + request.getContext().getName() + ", skipping SAML 2.0 based single-sign-on..."));
            }
            this.getNext().invoke(request, response);
            return;
        }
        this.requestResolver = new SSORequestResolver((HttpServletRequest)request, this.contextConfiguration);
        if (this.requestResolver.isURLToSkip()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"Request matched a URL to skip. Skipping...");
            }
            this.getNext().invoke(request, response);
            return;
        }
        try {
            if (this.requestResolver.isSAML2SSOResponse()) {
                if (this.containerLog.isDebugEnabled()) {
                    this.containerLog.debug((Object)"Processing a SAML 2.0 Response...");
                }
                this.handleResponse(request);
                if (request.getSession(false) != null) {
                    String relayStateID = (String)request.getSession(false).getAttribute("RelayStateId");
                    Map relayState = (Map)request.getSession(false).getAttribute(relayStateID);
                    String requestURL = (String)relayState.get("RequestURL");
                    String requestQueryString = (String)relayState.get("RequestQueryString");
                    Map requestParameters = (Map)relayState.get("RequestParams");
                    StringBuilder requestedURI = new StringBuilder(requestURL);
                    Optional.ofNullable(requestQueryString).ifPresent(queryString -> requestedURI.append("?").append((String)queryString));
                    Optional.ofNullable(requestParameters).ifPresent(queryParameters -> request.getSession(false).setAttribute("RequestParamMap", queryParameters));
                    response.sendRedirect(requestedURI.toString());
                    return;
                }
            } else {
                if (this.requestResolver.isSLOURL()) {
                    if (this.containerLog.isDebugEnabled()) {
                        this.containerLog.debug((Object)"Processing SAML 2.0 Single Logout URL...");
                    }
                    this.handleLogoutRequest(request, response);
                    return;
                }
                if (request.getSession(false) == null || request.getSession(false).getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession") == null) {
                    if (this.containerLog.isDebugEnabled()) {
                        this.containerLog.debug((Object)"Processing an SAML 2.0 Authentication Request...");
                    }
                    this.handleUnauthenticatedRequest(request, response);
                    return;
                }
            }
        }
        catch (SSOException e) {
            this.containerLog.error((Object)"An error has occurred when processing the request", (Throwable)((Object)e));
            this.getNext().invoke(request, response);
        }
        this.getNext().invoke(request, response);
    }

    private void handleUnauthenticatedRequest(Request request, Response response) throws SSOException {
        if (this.contextConfiguration == null) {
            throw new SSOException("Context level configurations may not be initialized");
        }
        if (this.requestResolver == null) {
            throw new SSOException("SSO Agent request resolver has not been initialized");
        }
        SAML2SSOManager manager = new SAML2SSOManager(this.contextConfiguration);
        String relayStateID = SSOUtils.createID();
        request.getSession(true).setAttribute("RelayStateId", (Object)relayStateID);
        request.getSession(false).setAttribute(relayStateID, SSOUtils.generateRelayState(request));
        this.contextConfiguration.enableRequestSigning(Optional.ofNullable(this.contextConfiguration.isRequestSigningEnabled()).orElse(false));
        if (this.requestResolver.isHttpPOSTBinding()) {
            this.containerLog.debug((Object)"Handling the SAML 2.0 Authentication Request for HTTP-POST binding...");
            String htmlPayload = manager.handleAuthenticationRequestForPOSTBinding(request);
            response.setContentType("text/html");
            SSOUtils.sendCharacterData((HttpServletResponse)response, htmlPayload);
        } else {
            this.containerLog.debug((Object)("Handling the SAML 2.0 Authentication Request for " + this.contextConfiguration.getHttpBinding() + "..."));
            try {
                response.sendRedirect(manager.handleAuthenticationRequestForRedirectBinding(request));
            }
            catch (IOException e) {
                throw new SSOException("Error when handling SAML 2.0 HTTP-Redirect binding", e);
            }
        }
    }

    private void handleResponse(Request request) throws SSOException {
        if (this.contextConfiguration == null) {
            throw new SSOException("Context level configurations may not be initialized");
        }
        this.contextConfiguration.enableResponseSigning(Optional.ofNullable(this.contextConfiguration.isResponseSigningEnabled()).orElse(false));
        this.contextConfiguration.enableAssertionSigning(Optional.ofNullable(this.contextConfiguration.isAssertionSigningEnabled()).orElse(true));
        this.contextConfiguration.enableAssertionEncryption(Optional.ofNullable(this.contextConfiguration.isAssertionEncryptionEnabled()).orElse(false));
        SAML2SSOManager manager = new SAML2SSOManager(this.contextConfiguration);
        manager.processResponse(request);
    }

    private void handleLogoutRequest(Request request, Response response) throws SSOException {
        if (this.requestResolver == null) {
            throw new SSOException("SSO Agent request resolver has not been initialized");
        }
        SAML2SSOManager manager = new SAML2SSOManager(this.contextConfiguration);
        try {
            if (this.requestResolver.isHttpPOSTBinding()) {
                if (request.getSession(false).getAttribute("org.wso2.appserver.webapp.security.bean.LoggedInSession") != null) {
                    String htmlPayload = manager.handleLogoutRequestForPOSTBinding(request);
                    response.setContentType("text/html");
                    SSOUtils.sendCharacterData((HttpServletResponse)response, htmlPayload);
                } else {
                    this.containerLog.warn((Object)"Attempt to logout from an already logged out session");
                    response.sendRedirect(request.getContext().getPath());
                }
            } else {
                response.sendRedirect(manager.handleLogoutRequestForRedirectBinding(request));
            }
        }
        catch (IOException e) {
            throw new SSOException("Error when handling logout request", e);
        }
    }
}

