/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.saml.signature;

import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.wso2.appserver.webapp.security.saml.signature.SSOX509Credential;
import org.wso2.appserver.webapp.security.saml.signature.SignatureValidator;
import org.wso2.appserver.webapp.security.saml.signature.X509CredentialImplementation;
import org.wso2.appserver.webapp.security.utils.exception.SSOException;

public class SAMLSignatureValidatorImplementation
implements SignatureValidator {
    @Override
    public void validateSignature(Response response, Assertion assertion, boolean isResponseSigningEnabled, boolean isAssertionSigningEnabled) throws SSOException {
        SSOX509Credential ssoX509Credential = SSOX509Credential.getInstance();
        if (isResponseSigningEnabled) {
            if (response.getSignature() == null) {
                throw new SSOException("SAML 2.0 Response signing is enabled, but signature element not found in SAML 2.0 Response element");
            }
            try {
                org.opensaml.xmlsec.signature.support.SignatureValidator.validate((Signature)response.getSignature(), (Credential)new X509CredentialImplementation(ssoX509Credential.getEntityCertificate()));
            }
            catch (SignatureException e) {
                throw new SSOException("Signature validation failed for SAML 2.0 Response", e);
            }
        }
        if (isAssertionSigningEnabled) {
            if (assertion.getSignature() == null) {
                throw new SSOException("SAML 2.0 Assertion signing is enabled, but signature element not found in SAML 2.0 Assertion element");
            }
            try {
                org.opensaml.xmlsec.signature.support.SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)new X509CredentialImplementation(ssoX509Credential.getEntityCertificate()));
            }
            catch (SignatureException e) {
                throw new SSOException("Signature validation failed for SAML 2.0 Assertion", e);
            }
        }
    }
}

