/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.webapp.security.saml.signature;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.wso2.appserver.webapp.security.saml.signature.SSOX509Credential;
import org.wso2.appserver.webapp.security.utils.exception.SSOException;

public class X509CredentialImplementation
implements X509Credential {
    private PublicKey publicKey;
    private X509Certificate entityCertificate;
    private PrivateKey privateKey;

    public X509CredentialImplementation(X509Certificate certificate) {
        this.publicKey = certificate.getPublicKey();
        this.entityCertificate = certificate;
    }

    public X509CredentialImplementation(SSOX509Credential credential) throws SSOException {
        this.publicKey = credential.getPublicKey();
        this.entityCertificate = credential.getEntityCertificate();
        this.privateKey = credential.getPrivateKey();
    }

    @Nullable
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Nullable
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Nonnull
    public X509Certificate getEntityCertificate() {
        return this.entityCertificate;
    }

    @Nonnull
    public Collection<X509Certificate> getEntityCertificateChain() {
        return new ArrayList<X509Certificate>();
    }

    @Nullable
    public Collection<X509CRL> getCRLs() {
        return new ArrayList<X509CRL>();
    }

    @Nullable
    public String getEntityId() {
        return null;
    }

    @Nullable
    public UsageType getUsageType() {
        return null;
    }

    @Nonnull
    public Collection<String> getKeyNames() {
        return new ArrayList<String>();
    }

    @Nullable
    public SecretKey getSecretKey() {
        return null;
    }

    @Nullable
    public CredentialContextSet getCredentialContextSet() {
        return null;
    }

    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return this.getClass();
    }
}

