/*
 * Decompiled with CFR 0.152.
 */
package demo.hw.client;

import demo.hw.client.TestAsyncHandler;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.hello_world_async_soap_http.GreeterAsync;
import org.apache.hello_world_async_soap_http.SOAPService;
import org.apache.hello_world_async_soap_http.types.GreetMeSometimeResponse;

public final class Client {
    private static final QName SERVICE_NAME = new QName("http://apache.org/hello_world_async_soap_http", "SOAPService");

    private Client() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("please specify wsdl");
            System.exit(1);
        }
        File wsdl = new File(args[0]);
        SOAPService ss = new SOAPService(wsdl.toURL(), SERVICE_NAME);
        ExecutorService executor = Executors.newFixedThreadPool(5);
        ss.setExecutor((Executor)executor);
        GreeterAsync port = ss.getSoapPort();
        TestAsyncHandler testAsyncHandler = new TestAsyncHandler();
        System.out.println("Invoking greetMeSometimeAsync using callback object...");
        Future response = port.greetMeSometimeAsync(System.getProperty("user.name"), (AsyncHandler)testAsyncHandler);
        while (!response.isDone()) {
            Thread.sleep(100L);
        }
        String resp = testAsyncHandler.getResponse();
        System.out.println();
        System.out.println("Server responded through callback with: " + resp);
        System.out.println();
        System.out.println("Invoking greetMeSometimeAsync using polling...");
        Response greetMeSomeTimeResp = port.greetMeSometimeAsync(System.getProperty("user.name"));
        while (!greetMeSomeTimeResp.isDone()) {
            Thread.sleep(100L);
        }
        GreetMeSometimeResponse reply = (GreetMeSometimeResponse)greetMeSomeTimeResp.get();
        System.out.println("Server responded through polling with: " + reply.getResponseType());
        System.exit(0);
    }
}

