/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.common.artifact.cache;

import java.io.IOException;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheRetrieverServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(CacheRetrieverServlet.class);
    private CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager("tsampleCacheManager");
    private Cache<String, String> cache = this.cacheManager.getCache("sampleCache");
    private static final String SET_CACHE = "setCache";
    private static final String GET_CACHE = "getCache";
    private static final String RANDOM_CACHE = "randomCache";
    private static final String TEMP_CACHE_VALUE = "tempCacheValue";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    private void doProcess(HttpServletRequest request, HttpServletResponse response) {
        String action = request.getParameter("action");
        String key = request.getParameter("key");
        if (action != null && !action.isEmpty() && key != null) {
            switch (action) {
                case "setCache": {
                    this.setCache(key, request, response);
                    break;
                }
                case "getCache": {
                    this.getCache(key, request, response);
                    break;
                }
                case "randomCache": {
                    this.getRandomCacheManager(key, request, response);
                }
            }
        } else {
            log.info((Object)"action and key should be initialized");
        }
    }

    private void getRandomCacheManager(String key, HttpServletRequest request, HttpServletResponse response) {
        CacheManager defaultCacheMgr = Caching.getCacheManager();
        Cache randomCache = defaultCacheMgr.getCache(RANDOM_CACHE);
        randomCache.put((Object)key, (Object)"tmpCacheValue");
        response.addHeader("tmpCacheValue", (String)randomCache.get((Object)key));
    }

    private void setCache(String key, HttpServletRequest request, HttpServletResponse response) {
        String value = request.getParameter("value");
        this.cache.put((Object)key, (Object)value);
        String setValue = (String)this.cache.get((Object)key);
        response.addHeader("added-cached-value", setValue);
    }

    private void getCache(String key, HttpServletRequest request, HttpServletResponse response) {
        String returnVal = (String)this.cache.get((Object)key);
        if (returnVal == null) {
            this.cache.put((Object)key, (Object)TEMP_CACHE_VALUE);
            returnVal = (String)this.cache.get((Object)key);
        }
        response.addHeader("cached-value", returnVal);
    }
}

