/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.common.artifact.carboncontext;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;

public class OSGiServiceServlet
extends HttpServlet {
    private static final String CARBON_CONTEXT = "cc";
    private static final String PRIVILEGE_CARBON_CONTEXT = "pcc";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    private void doProcess(HttpServletRequest request, HttpServletResponse response) {
        String action = request.getParameter("action");
        Object osGiService = null;
        if (CARBON_CONTEXT.equalsIgnoreCase(action)) {
            osGiService = CarbonContext.getThreadLocalCarbonContext().getOSGiService(CarbonTomcatService.class, null);
        } else if (PRIVILEGE_CARBON_CONTEXT.equalsIgnoreCase(action)) {
            osGiService = PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(CarbonTomcatService.class, null);
        }
        if (osGiService != null && osGiService instanceof CarbonTomcatService) {
            CarbonTomcatService carbonTomcatService = (CarbonTomcatService)osGiService;
            response.addHeader("tomcat-service-name", carbonTomcatService.getTomcat().getService().getName());
        }
    }
}

