/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.samples.jndi;

import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(value={"/carbon-datasource-lookup"})
public class CarbonDataSourceLookupServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(CarbonDataSourceLookupServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        try {
            String dsName = request.getParameter("dsName");
            InitialContext initCtx = new InitialContext();
            DataSource dataSource = (DataSource)initCtx.lookup(dsName);
            out.write("DataSourceAvailable");
        }
        catch (NamingException e) {
            log.error((Object)"JNDI resource not available", (Throwable)e);
            out.write("DataSourceNotFound");
        }
    }
}

