/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.sample.utils;

import java.util.ArrayList;
import java.util.List;
import org.wso2.appserver.configuration.context.AppServerWebAppConfiguration;
import org.wso2.appserver.configuration.context.ClassLoaderConfiguration;
import org.wso2.appserver.configuration.context.SSOConfiguration;
import org.wso2.appserver.configuration.context.StatsPublisherConfiguration;

public class ContextConfigurationUtils {
    public static AppServerWebAppConfiguration prepareDefault() {
        AppServerWebAppConfiguration configuration = new AppServerWebAppConfiguration();
        configuration.setClassLoaderConfiguration(ContextConfigurationUtils.prepareClassLoaderConfiguration());
        configuration.setSingleSignOnConfiguration(ContextConfigurationUtils.prepareSSOConfiguration());
        configuration.setStatsPublisherConfiguration(ContextConfigurationUtils.prepareStatsPublisherConfiguration());
        return configuration;
    }

    private static ClassLoaderConfiguration prepareClassLoaderConfiguration() {
        ClassLoaderConfiguration classloading = new ClassLoaderConfiguration();
        classloading.setEnvironments("Spring");
        return classloading;
    }

    private static SSOConfiguration prepareSSOConfiguration() {
        SSOConfiguration ssoConfiguration = new SSOConfiguration();
        SSOConfiguration.SkipURIs skipURIs = new SSOConfiguration.SkipURIs();
        ArrayList<String> uris = new ArrayList<String>();
        uris.add("http://www.example.com");
        skipURIs.setSkipURIs(uris);
        ssoConfiguration.setSkipURIs(skipURIs);
        ssoConfiguration.enableHandlingConsumerURLAfterSLO(Boolean.valueOf(true));
        ssoConfiguration.setQueryParams("tenant=admin&dialect=SAML");
        ssoConfiguration.setApplicationServerURL("https://localhost:8443");
        ssoConfiguration.enableSSO(Boolean.valueOf(true));
        ssoConfiguration.setRequestURLPostfix("samlsso");
        ssoConfiguration.setHttpBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        ssoConfiguration.setIssuerId("foo-app");
        ssoConfiguration.setConsumerURL("https://localhost:8443/foo-app/acs");
        ssoConfiguration.setConsumerURLPostfix("/acs");
        ssoConfiguration.setAttributeConsumingServiceIndex("1784849");
        ssoConfiguration.enableSLO(Boolean.valueOf(true));
        ssoConfiguration.setSLOURLPostfix("logout");
        ssoConfiguration.enableAssertionSigning(Boolean.valueOf(true));
        ssoConfiguration.enableAssertionEncryption(Boolean.valueOf(true));
        ssoConfiguration.enableRequestSigning(Boolean.valueOf(true));
        ssoConfiguration.enableResponseSigning(Boolean.valueOf(true));
        ssoConfiguration.enableForceAuthn(Boolean.valueOf(false));
        ssoConfiguration.enablePassiveAuthn(Boolean.valueOf(false));
        SSOConfiguration.Property relayState = new SSOConfiguration.Property();
        relayState.setKey("RelayState");
        relayState.setValue("index.jsp");
        SSOConfiguration.Property loginURL = new SSOConfiguration.Property();
        loginURL.setKey("LoginURL");
        loginURL.setValue("index.jsp");
        ArrayList<SSOConfiguration.Property> properties = new ArrayList<SSOConfiguration.Property>();
        properties.add(relayState);
        properties.add(loginURL);
        ssoConfiguration.setProperties(properties);
        return ssoConfiguration;
    }

    private static StatsPublisherConfiguration prepareStatsPublisherConfiguration() {
        StatsPublisherConfiguration configuration = new StatsPublisherConfiguration();
        configuration.enableStatsPublisher(Boolean.valueOf(true));
        return configuration;
    }

    public static boolean compare(AppServerWebAppConfiguration actual, AppServerWebAppConfiguration expected) {
        return ContextConfigurationUtils.compareClassloadingConfigs(actual.getClassLoaderConfiguration(), expected.getClassLoaderConfiguration()) && ContextConfigurationUtils.compareSSOConfigurations(actual.getSingleSignOnConfiguration(), expected.getSingleSignOnConfiguration()) && ContextConfigurationUtils.compareStatsPublisherConfigs(actual.getStatsPublisherConfiguration(), expected.getStatsPublisherConfiguration());
    }

    private static boolean compareClassloadingConfigs(ClassLoaderConfiguration actual, ClassLoaderConfiguration expected) {
        return actual != null && expected != null && actual.getEnvironments().trim().equals(expected.getEnvironments());
    }

    private static boolean compareSSOConfigurations(SSOConfiguration actual, SSOConfiguration expected) {
        if (actual != null && expected != null) {
            boolean skipURIs = ContextConfigurationUtils.compareSkipURIs(actual.getSkipURIs(), expected.getSkipURIs());
            boolean handlingConsumerURLAfterSLO = actual.handleConsumerURLAfterSLO().equals(expected.handleConsumerURLAfterSLO());
            boolean queryParams = actual.getQueryParams().trim().equals(expected.getQueryParams());
            boolean appServerURL = actual.getApplicationServerURL().trim().equals(expected.getApplicationServerURL());
            boolean enableSSO = actual.isSSOEnabled().equals(expected.isSSOEnabled());
            boolean binding = actual.getHttpBinding().trim().equals(expected.getHttpBinding());
            boolean issuerID = actual.getIssuerId().trim().equals(expected.getIssuerId());
            boolean consumerURL = actual.getConsumerURL().trim().equals(expected.getConsumerURL());
            boolean serviceIndex = actual.getAttributeConsumingServiceIndex().trim().equals(expected.getAttributeConsumingServiceIndex());
            boolean enableSLO = actual.isSLOEnabled().equals(expected.isSLOEnabled());
            boolean ssl = ContextConfigurationUtils.compareSSLProperties(actual, expected);
            boolean forceAuthn = actual.isForceAuthnEnabled().equals(expected.isForceAuthnEnabled());
            boolean passiveAuthn = actual.isPassiveAuthnEnabled().equals(expected.isPassiveAuthnEnabled());
            boolean postfixes = ContextConfigurationUtils.comparePostfixes(actual, expected);
            boolean properties = ContextConfigurationUtils.compareProperties(actual.getProperties(), expected.getProperties());
            return skipURIs && handlingConsumerURLAfterSLO && queryParams && appServerURL && enableSSO && postfixes && binding && issuerID && consumerURL && serviceIndex && enableSLO && ssl && forceAuthn && passiveAuthn && properties;
        }
        return actual == null && expected == null;
    }

    private static boolean compareSkipURIs(SSOConfiguration.SkipURIs actual, SSOConfiguration.SkipURIs expected) {
        return actual.getSkipURIs().stream().filter(skipURI -> expected.getSkipURIs().stream().filter(uri -> uri.trim().equals(skipURI)).count() > 0L).count() == (long)expected.getSkipURIs().size();
    }

    private static boolean compareProperties(List<SSOConfiguration.Property> actual, List<SSOConfiguration.Property> expected) {
        return actual.stream().filter(property -> expected.stream().filter(exp -> property.getKey().trim().equals(exp.getKey()) && property.getValue().trim().equals(exp.getValue())).count() > 0L).count() == (long)expected.size();
    }

    private static boolean compareSSLProperties(SSOConfiguration actual, SSOConfiguration expected) {
        boolean assertionSigning = actual.isAssertionSigningEnabled().equals(expected.isAssertionSigningEnabled());
        boolean assertionEncryption = actual.isAssertionEncryptionEnabled().equals(expected.isAssertionEncryptionEnabled());
        boolean requestSigning = actual.isRequestSigningEnabled().equals(expected.isRequestSigningEnabled());
        boolean responseSigning = actual.isResponseSigningEnabled().equals(expected.isResponseSigningEnabled());
        return assertionSigning && assertionEncryption && requestSigning && responseSigning;
    }

    private static boolean comparePostfixes(SSOConfiguration actual, SSOConfiguration expected) {
        boolean requestURLPostfix = actual.getRequestURLPostfix().trim().equals(expected.getRequestURLPostfix());
        boolean consumerURLPostfix = actual.getConsumerURLPostfix().trim().equals(expected.getConsumerURLPostfix());
        boolean sloURLPostfix = actual.getSLOURLPostfix().trim().equals(expected.getSLOURLPostfix());
        return requestURLPostfix && consumerURLPostfix && sloURLPostfix;
    }

    private static boolean compareStatsPublisherConfigs(StatsPublisherConfiguration actual, StatsPublisherConfiguration expected) {
        return actual != null && expected != null && actual.isStatsPublisherEnabled().equals(expected.isStatsPublisherEnabled());
    }
}

