/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.sample.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.wso2.appserver.configuration.server.AppServerConfiguration;
import org.wso2.appserver.configuration.server.ClassLoaderEnvironments;
import org.wso2.appserver.configuration.server.SSOConfiguration;
import org.wso2.appserver.configuration.server.SecurityConfiguration;
import org.wso2.appserver.configuration.server.StatsPublisherConfiguration;

public class ServerConfigurationUtils {
    private static final StrSubstitutor STRING_SUB = new StrSubstitutor(System.getenv());

    public static AppServerConfiguration generateDefault() {
        AppServerConfiguration appServerConfiguration = new AppServerConfiguration();
        appServerConfiguration.setClassLoaderEnvironments(ServerConfigurationUtils.prepareClassLoaderEnv());
        appServerConfiguration.setSingleSignOnConfiguration(ServerConfigurationUtils.prepareSSOConfigs());
        appServerConfiguration.setStatsPublisherConfiguration(ServerConfigurationUtils.prepareStatsPublishingConfigs());
        appServerConfiguration.setSecurityConfiguration(ServerConfigurationUtils.prepareSecurityConfigs());
        return appServerConfiguration;
    }

    private static ClassLoaderEnvironments prepareClassLoaderEnv() {
        ClassLoaderEnvironments classloadingEnvironments = new ClassLoaderEnvironments();
        ClassLoaderEnvironments.Environment cxf = new ClassLoaderEnvironments.Environment();
        cxf.setName("CXF");
        cxf.setClasspath("${catalina.base}/lib/runtimes/cxf/");
        ArrayList<ClassLoaderEnvironments.Environment> envList = new ArrayList<ClassLoaderEnvironments.Environment>();
        envList.add(cxf);
        envList.forEach(environment -> environment.setClasspath(STRING_SUB.replace(environment.getClasspath())));
        envList.forEach(environment -> environment.setClasspath(StrSubstitutor.replaceSystemProperties((Object)environment.getClasspath())));
        ClassLoaderEnvironments.Environments environments = new ClassLoaderEnvironments.Environments();
        environments.setEnvironments(envList);
        classloadingEnvironments.setEnvironments(environments);
        return classloadingEnvironments;
    }

    private static SSOConfiguration prepareSSOConfigs() {
        SSOConfiguration ssoConfiguration = new SSOConfiguration();
        ssoConfiguration.setIdpURL("https://localhost:9443/samlsso");
        ssoConfiguration.setIdpEntityId("localhost");
        ssoConfiguration.setSignatureValidatorImplClass("org.wso2.appserver.webapp.security.signature.SAMLSignatureValidatorImplementation");
        ssoConfiguration.setIdpCertificateAlias("wso2carbon");
        return ssoConfiguration;
    }

    private static StatsPublisherConfiguration prepareStatsPublishingConfigs() {
        StatsPublisherConfiguration configuration = new StatsPublisherConfiguration();
        configuration.setUsername("admin");
        configuration.setPassword("admin");
        configuration.setDataAgentType("Thrift");
        configuration.setAuthenticationURL("ssl://127.0.0.1:7711");
        configuration.setPublisherURL("tcp://127.0.0.1:7611");
        configuration.setStreamId("org.wso2.http.stats:1.0.0");
        return configuration;
    }

    private static SecurityConfiguration prepareSecurityConfigs() {
        SecurityConfiguration configuration = new SecurityConfiguration();
        SecurityConfiguration.Keystore keystore = new SecurityConfiguration.Keystore();
        keystore.setLocation("${catalina.base}/keystore.jks");
        keystore.setPassword("wso2carbon");
        keystore.setType("JKS");
        keystore.setKeyAlias("wso2carbon");
        keystore.setKeyPassword("wso2carbon");
        SecurityConfiguration.Truststore truststore = new SecurityConfiguration.Truststore();
        truststore.setLocation("${catalina.base}/conf/wso2/client-truststore.jks");
        truststore.setType("JKS");
        truststore.setPassword("wso2carbon");
        configuration.setKeystore(keystore);
        configuration.setTruststore(truststore);
        configuration.getKeystore().setLocation(STRING_SUB.replace(configuration.getKeystore().getLocation()));
        configuration.getTruststore().setLocation(STRING_SUB.replace(configuration.getTruststore().getLocation()));
        configuration.getKeystore().setLocation(StrSubstitutor.replaceSystemProperties((Object)configuration.getKeystore().getLocation()));
        configuration.getTruststore().setLocation(StrSubstitutor.replaceSystemProperties((Object)configuration.getTruststore().getLocation()));
        return configuration;
    }

    public static boolean compare(AppServerConfiguration actual, AppServerConfiguration expected) {
        boolean classloading = ServerConfigurationUtils.compareClassloadingConfigurations(actual.getClassLoaderEnvironments(), expected.getClassLoaderEnvironments());
        boolean sso = ServerConfigurationUtils.compareSSOConfigurations(actual.getSingleSignOnConfiguration(), expected.getSingleSignOnConfiguration());
        boolean statsPublishing = ServerConfigurationUtils.compareStatsPublishingConfigurations(actual.getStatsPublisherConfiguration(), expected.getStatsPublisherConfiguration());
        boolean security = ServerConfigurationUtils.compareSecurityConfigurations(actual.getSecurityConfiguration(), expected.getSecurityConfiguration());
        return classloading && sso && statsPublishing && security;
    }

    private static boolean compareClassloadingConfigurations(ClassLoaderEnvironments actual, ClassLoaderEnvironments expected) {
        if (actual != null && expected != null) {
            return actual.getEnvironments().getEnvironments().stream().filter(env -> expected.getEnvironments().getEnvironments().stream().filter(expectedEnv -> expectedEnv.getName().equals(env.getName().trim()) && expectedEnv.getClasspath().equals(env.getClasspath().trim())).count() == 1L).count() == (long)expected.getEnvironments().getEnvironments().size();
        }
        return actual == null && expected == null;
    }

    private static boolean compareSSOConfigurations(SSOConfiguration actual, SSOConfiguration expected) {
        if (actual != null && expected != null) {
            boolean idpURL = actual.getIdpURL().trim().equals(expected.getIdpURL());
            boolean idpEntityID = actual.getIdpEntityId().trim().equals(expected.getIdpEntityId());
            boolean validatorClass = actual.getSignatureValidatorImplClass().trim().equals(expected.getSignatureValidatorImplClass());
            boolean idpCertAlias = actual.getIdpCertificateAlias().trim().equals(expected.getIdpCertificateAlias());
            boolean properties = ServerConfigurationUtils.compareSSOProperties(actual.getProperties(), expected.getProperties());
            return idpURL && idpEntityID && validatorClass && idpCertAlias && properties;
        }
        return actual == null && expected == null;
    }

    private static boolean compareSSOProperties(List<SSOConfiguration.Property> actual, List<SSOConfiguration.Property> expected) {
        if (actual != null && expected != null) {
            return actual.stream().filter(property -> expected.stream().filter(expProperty -> expProperty.getKey().equals(property.getKey()) && expProperty.getValue().equals(property.getValue())).count() > 0L).count() == (long)expected.size();
        }
        return actual == null && expected == null;
    }

    private static boolean compareStatsPublishingConfigurations(StatsPublisherConfiguration actual, StatsPublisherConfiguration expected) {
        if (actual != null && expected != null) {
            boolean username = actual.getUsername().trim().equals(expected.getUsername());
            boolean password = actual.getPassword().trim().equals(expected.getPassword());
            boolean dataAgent = actual.getDataAgentType().trim().equals(expected.getDataAgentType());
            boolean authnURL = actual.getAuthenticationURL().trim().equals(expected.getAuthenticationURL());
            boolean publisherURL = actual.getPublisherURL().trim().equals(expected.getPublisherURL());
            boolean streamID = actual.getStreamId().trim().equals(expected.getStreamId());
            return username && password && dataAgent && authnURL && publisherURL && streamID;
        }
        return actual == null && expected == null;
    }

    private static boolean compareSecurityConfigurations(SecurityConfiguration actual, SecurityConfiguration expected) {
        if (actual != null && expected != null) {
            boolean privateKeyPassword = false;
            boolean privateKeyAlias = false;
            boolean type = false;
            boolean keystorePassword = false;
            boolean keystorePath = false;
            if (actual.getKeystore() != null && expected.getKeystore() != null) {
                keystorePath = actual.getKeystore().getLocation().trim().equals(expected.getKeystore().getLocation());
                keystorePassword = actual.getKeystore().getPassword().trim().equals(expected.getKeystore().getPassword());
                type = actual.getKeystore().getType().trim().equals(expected.getKeystore().getType());
                privateKeyAlias = actual.getKeystore().getKeyAlias().trim().equals(expected.getKeystore().getKeyAlias());
                privateKeyPassword = actual.getKeystore().getKeyPassword().trim().equals(expected.getKeystore().getKeyPassword());
            } else if (actual.getKeystore() == null && expected.getKeystore() == null) {
                keystorePath = true;
                keystorePassword = true;
                type = true;
                privateKeyAlias = true;
                privateKeyPassword = true;
            }
            boolean truststoreType = false;
            boolean truststorePassword = false;
            boolean truststorePath = false;
            if (actual.getTruststore() != null && expected.getTruststore() != null) {
                truststorePath = actual.getTruststore().getLocation().trim().equals(expected.getTruststore().getLocation());
                truststorePassword = actual.getTruststore().getPassword().trim().equals(expected.getTruststore().getPassword());
                truststoreType = actual.getTruststore().getType().trim().equals(expected.getTruststore().getType());
            } else if (actual.getTruststore() == null && expected.getTruststore() == null) {
                truststorePath = true;
                truststorePassword = true;
                truststoreType = true;
            }
            return keystorePath && keystorePassword && type && privateKeyAlias && privateKeyPassword && truststorePath && truststorePassword && truststoreType;
        }
        return actual == null && expected == null;
    }
}

