/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.sample;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.wso2.appserver.configuration.context.AppServerWebAppConfiguration;
import org.wso2.appserver.configuration.listeners.ContextConfigurationLoader;
import org.wso2.appserver.configuration.listeners.ServerConfigurationLoader;
import org.wso2.appserver.configuration.server.AppServerConfiguration;
import org.wso2.appserver.sample.utils.ContextConfigurationUtils;
import org.wso2.appserver.sample.utils.ServerConfigurationUtils;

public class ConfigurationLoaderValve
extends ValveBase {
    public void invoke(Request request, Response response) throws IOException, ServletException {
        AppServerConfiguration expectedServerConfiguration = ServerConfigurationUtils.generateDefault();
        AppServerConfiguration actualServerConfiguration = ServerConfigurationLoader.getServerConfiguration();
        boolean isServerConfigurationUniform = ServerConfigurationUtils.compare(actualServerConfiguration, expectedServerConfiguration);
        request.setAttribute("isServerConfigurationUniform", (Object)isServerConfigurationUniform);
        Optional expectedWebAppConfiguration = ContextConfigurationLoader.getContextConfiguration((Context)request.getContext());
        AppServerWebAppConfiguration actualWebAppConfiguration = ContextConfigurationUtils.prepareDefault();
        expectedWebAppConfiguration.ifPresent(configuration -> {
            boolean isContextConfigurationUniform = ContextConfigurationUtils.compare(actualWebAppConfiguration, configuration);
            request.setAttribute("isContextConfigurationUniform", (Object)isContextConfigurationUniform);
        });
        this.getNext().invoke(request, response);
    }
}

