/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.sample.utils;

import java.util.ArrayList;
import java.util.List;
import org.wso2.appserver.configuration.context.AppServerWebAppConfiguration;
import org.wso2.appserver.configuration.context.WebAppClassLoading;
import org.wso2.appserver.configuration.context.WebAppSingleSignOn;
import org.wso2.appserver.configuration.context.WebAppStatsPublishing;

public class ContextConfigurationUtils {
    public static AppServerWebAppConfiguration prepareDefault() {
        AppServerWebAppConfiguration configuration = new AppServerWebAppConfiguration();
        configuration.setClassLoaderConfiguration(ContextConfigurationUtils.prepareClassLoaderConfiguration());
        configuration.setSingleSignOnConfiguration(ContextConfigurationUtils.prepareSSOConfiguration());
        configuration.setStatsPublisherConfiguration(ContextConfigurationUtils.prepareStatsPublisherConfiguration());
        return configuration;
    }

    private static WebAppClassLoading prepareClassLoaderConfiguration() {
        WebAppClassLoading classloading = new WebAppClassLoading();
        classloading.setEnvironments("Spring");
        return classloading;
    }

    private static WebAppSingleSignOn prepareSSOConfiguration() {
        WebAppSingleSignOn ssoConfiguration = new WebAppSingleSignOn();
        ssoConfiguration.enableSSO(Boolean.valueOf(true));
        ssoConfiguration.setHttpBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        ssoConfiguration.setIssuerId("foo-app");
        ssoConfiguration.setConsumerURL("https://localhost:8443/foo-app/acs");
        ssoConfiguration.setConsumerURLPostfix("acs");
        WebAppSingleSignOn.SkipURIs skipURIs = new WebAppSingleSignOn.SkipURIs();
        ArrayList<String> uris = new ArrayList<String>();
        uris.add("http://www.example.com");
        skipURIs.setSkipURIs(uris);
        ssoConfiguration.setSkipURIs(skipURIs);
        ssoConfiguration.setOptionalParams("tenant=admin&dialect=SAML");
        ssoConfiguration.enableSLO(Boolean.valueOf(true));
        ssoConfiguration.setSLOURLPostfix("logout");
        ssoConfiguration.enableAssertionSigning(Boolean.valueOf(true));
        ssoConfiguration.enableAssertionEncryption(Boolean.valueOf(true));
        ssoConfiguration.enableRequestSigning(Boolean.valueOf(true));
        ssoConfiguration.enableResponseSigning(Boolean.valueOf(true));
        WebAppSingleSignOn.Property relayState = new WebAppSingleSignOn.Property();
        relayState.setKey("RelayState");
        relayState.setValue("index.jsp");
        WebAppSingleSignOn.Property loginURL = new WebAppSingleSignOn.Property();
        loginURL.setKey("LoginURL");
        loginURL.setValue("index.jsp");
        ArrayList<WebAppSingleSignOn.Property> properties = new ArrayList<WebAppSingleSignOn.Property>();
        properties.add(relayState);
        properties.add(loginURL);
        ssoConfiguration.setProperties(properties);
        return ssoConfiguration;
    }

    private static WebAppStatsPublishing prepareStatsPublisherConfiguration() {
        WebAppStatsPublishing configuration = new WebAppStatsPublishing();
        configuration.enableStatsPublisher(Boolean.valueOf(true));
        return configuration;
    }

    public static boolean compare(AppServerWebAppConfiguration actual, AppServerWebAppConfiguration expected) {
        return ContextConfigurationUtils.compareClassloadingConfigs(actual.getClassLoaderConfiguration(), expected.getClassLoaderConfiguration()) && ContextConfigurationUtils.compareSSOConfigurations(actual.getSingleSignOnConfiguration(), expected.getSingleSignOnConfiguration()) && ContextConfigurationUtils.compareStatsPublisherConfigs(actual.getStatsPublisherConfiguration(), expected.getStatsPublisherConfiguration());
    }

    private static boolean compareClassloadingConfigs(WebAppClassLoading actual, WebAppClassLoading expected) {
        return actual != null && expected != null && actual.getEnvironments().trim().equals(expected.getEnvironments());
    }

    private static boolean compareSSOConfigurations(WebAppSingleSignOn actual, WebAppSingleSignOn expected) {
        if (actual != null && expected != null) {
            boolean skipURIs = ContextConfigurationUtils.compareSkipURIs(actual.getSkipURIs(), expected.getSkipURIs());
            boolean queryParams = actual.getOptionalParams().trim().equals(expected.getOptionalParams());
            boolean enableSSO = actual.isSSOEnabled().equals(expected.isSSOEnabled());
            boolean binding = actual.getHttpBinding().trim().equals(expected.getHttpBinding());
            boolean issuerID = actual.getIssuerId().trim().equals(expected.getIssuerId());
            boolean consumerURL = actual.getConsumerURL().trim().equals(expected.getConsumerURL());
            boolean enableSLO = actual.isSLOEnabled().equals(expected.isSLOEnabled());
            boolean ssl = ContextConfigurationUtils.compareSSLProperties(actual, expected);
            boolean postfixes = ContextConfigurationUtils.comparePostfixes(actual, expected);
            boolean properties = ContextConfigurationUtils.compareProperties(actual.getProperties(), expected.getProperties());
            return skipURIs && queryParams && enableSSO && postfixes && binding && issuerID && consumerURL && enableSLO && ssl && properties;
        }
        return actual == null && expected == null;
    }

    private static boolean compareSkipURIs(WebAppSingleSignOn.SkipURIs actual, WebAppSingleSignOn.SkipURIs expected) {
        return actual.getSkipURIs().stream().filter(skipURI -> expected.getSkipURIs().stream().filter(uri -> uri.trim().equals(skipURI)).count() > 0L).count() == (long)expected.getSkipURIs().size();
    }

    private static boolean compareProperties(List<WebAppSingleSignOn.Property> actual, List<WebAppSingleSignOn.Property> expected) {
        return actual.stream().filter(property -> expected.stream().filter(exp -> property.getKey().trim().equals(exp.getKey()) && property.getValue().trim().equals(exp.getValue())).count() > 0L).count() == (long)expected.size();
    }

    private static boolean compareSSLProperties(WebAppSingleSignOn actual, WebAppSingleSignOn expected) {
        boolean assertionSigning = actual.isAssertionSigningEnabled().equals(expected.isAssertionSigningEnabled());
        boolean assertionEncryption = actual.isAssertionEncryptionEnabled().equals(expected.isAssertionEncryptionEnabled());
        boolean requestSigning = actual.isRequestSigningEnabled().equals(expected.isRequestSigningEnabled());
        boolean responseSigning = actual.isResponseSigningEnabled().equals(expected.isResponseSigningEnabled());
        return assertionSigning && assertionEncryption && requestSigning && responseSigning;
    }

    private static boolean comparePostfixes(WebAppSingleSignOn actual, WebAppSingleSignOn expected) {
        boolean consumerURLPostfix = actual.getConsumerURLPostfix().trim().equals(expected.getConsumerURLPostfix());
        boolean sloURLPostfix = actual.getSLOURLPostfix().trim().equals(expected.getSLOURLPostfix());
        return consumerURLPostfix && sloURLPostfix;
    }

    private static boolean compareStatsPublisherConfigs(WebAppStatsPublishing actual, WebAppStatsPublishing expected) {
        return actual != null && expected != null && actual.isStatsPublisherEnabled().equals(expected.isStatsPublisherEnabled());
    }
}

