/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.hibernate;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.wso2.appserver.hibernate.Employee;

public class EmployeeManager {
    private static final Log log = LogFactory.getLog(EmployeeManager.class);
    private static SessionFactory factory = new Configuration().configure().buildSessionFactory();

    public static void main(String[] args) throws Exception {
        EmployeeManager employeeManager = new EmployeeManager();
        Integer id1 = employeeManager.addEmployee("Kasun", "Gajasinghe", 20000);
        Integer id2 = employeeManager.addEmployee("Alice", "Durham", 5000);
        Integer id3 = employeeManager.addEmployee("Joe", "Brown", 10000);
        List employees = employeeManager.getEmployees();
        employeeManager.updateEmployee(id1, Integer.valueOf(10000));
        employeeManager.deleteEmployee(id2);
        log.info((Object)"-----------------");
        for (Object employee1 : employees) {
            Employee employee = (Employee)employee1;
            log.info((Object)("First Name: " + employee.getFirstName()));
            log.info((Object)("Last Name: " + employee.getLastName()));
            log.info((Object)("Salary: " + employee.getSalary()));
            log.info((Object)"-----------------");
        }
    }

    public Integer addEmployee(String fname, String lname, int salary) {
        Session session = factory.openSession();
        Transaction tx = null;
        Integer employeeID = null;
        try {
            tx = session.beginTransaction();
            Employee employee = new Employee(fname, lname, salary);
            employeeID = (Integer)session.save((Object)employee);
            tx.commit();
        }
        catch (HibernateException e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            session.close();
        }
        return employeeID;
    }

    public List<Employee> getEmployees() {
        Transaction tx = null;
        try (Session session = factory.openSession();){
            tx = session.beginTransaction();
            List employees = session.createQuery("FROM Employee").list();
            tx.commit();
            List list = employees;
            return list;
        }
    }

    public void updateEmployee(Integer EmployeeID, Integer salary) {
        Transaction tx = null;
        try (Session session = factory.openSession();){
            tx = session.beginTransaction();
            Employee employee = (Employee)session.get(Employee.class, (Serializable)EmployeeID);
            employee.setSalary(salary);
            session.update((Object)employee);
            tx.commit();
        }
    }

    public void deleteEmployee(Integer EmployeeID) {
        Transaction tx = null;
        try (Session session = factory.openSession();){
            tx = session.beginTransaction();
            Employee employee = (Employee)session.get(Employee.class, (Serializable)EmployeeID);
            session.delete((Object)employee);
            tx.commit();
        }
    }
}

