/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.hibernate.service;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.appserver.hibernate.Employee;
import org.wso2.appserver.hibernate.EmployeeManager;
import org.wso2.appserver.hibernate.service.Employees;

@Path(value="/EmployeeService")
public class EmployeeService {
    EmployeeManager employeeManager = new EmployeeManager();
    private static final Log log = LogFactory.getLog(EmployeeService.class);

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/get")
    public Response getEmployees() {
        log.info((Object)"Get employees.");
        List employees = this.employeeManager.getEmployees();
        return Response.ok().entity((Object)new Employees(employees)).build();
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Path(value="/add")
    public Response addEmployee(Employees employees) {
        Employee employee = (Employee)employees.getEmployees().get(0);
        log.info((Object)("Received employee: " + employee.getFirstName()));
        String firstName = employee.getFirstName();
        String lastName = employee.getLastName();
        Integer salary = employee.getSalary();
        Integer id = this.employeeManager.addEmployee(firstName, lastName, salary.intValue());
        return Response.ok().entity((Object)id).build();
    }

    @PUT
    @Path(value="/update")
    public void updateEmployee(@FormParam(value="id") Integer id, @FormParam(value="salary") Integer salary) {
        log.info((Object)("Received id: " + id + ", salary: " + salary));
        this.employeeManager.updateEmployee(id, salary);
    }

    @DELETE
    @Path(value="/delete")
    public void deleteEmployee(@QueryParam(value="id") Integer id) {
        log.info((Object)("Received id: " + id));
        this.employeeManager.deleteEmployee(id);
    }
}

