/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.sample.service;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Service;
import org.wso2.appserver.sample.service.Customer;
import org.wso2.appserver.sample.service.Order;

@Service
@Path(value="/customerservice")
public class CustomerService {
    long currentId = 123L;
    Map<Long, Customer> customers = new HashMap();
    Map<Long, Order> orders = new HashMap();

    public CustomerService() {
        this.init();
    }

    @GET
    @Path(value="/customers/{id}/")
    @Produces(value={"application/xml"})
    public Customer getCustomer(@PathParam(value="id") String id) {
        long idNumber = Long.parseLong(id);
        return (Customer)this.customers.get(idNumber);
    }

    @PUT
    @Path(value="/customers/")
    @Consumes(value={"text/xml"})
    public Response updateCustomer(Customer customer) {
        Response r;
        Customer c = (Customer)this.customers.get(customer.getId());
        if (c != null) {
            this.customers.put(customer.getId(), customer);
            r = Response.ok((Object)customer).build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @POST
    @Path(value="/customers/")
    @Consumes(value={"text/xml"})
    public Response addCustomer(Customer customer) {
        customer.setId(++this.currentId);
        this.customers.put(customer.getId(), customer);
        return Response.ok((Object)customer).build();
    }

    @POST
    @Path(value="/customers/name/")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String getCustomerName(String id) {
        return "Isuru Suriarachchi";
    }

    @DELETE
    @Path(value="/customers/{id}/")
    public Response deleteCustomer(@PathParam(value="id") String id) {
        Response r;
        long idNumber = Long.parseLong(id);
        Customer c = (Customer)this.customers.get(idNumber);
        if (c != null) {
            r = Response.ok().build();
            this.customers.remove(idNumber);
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @Path(value="/orders/{orderId}/")
    public Order getOrder(@PathParam(value="orderId") String orderId) {
        long idNumber = Long.parseLong(orderId);
        return (Order)this.orders.get(idNumber);
    }

    final void init() {
        Customer c = new Customer();
        c.setName("John");
        c.setId(123L);
        this.customers.put(c.getId(), c);
        Order o = new Order();
        o.setDescription("order 223");
        o.setId(223L);
        this.orders.put(o.getId(), o);
    }
}

