/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.sample.ee.jpa.servlet;

import java.io.IOException;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openjpa.persistence.PersistenceException;
import org.wso2.appserver.sample.ee.jpa.servlet.Order;
import org.wso2.appserver.sample.ee.jpa.servlet.OrderManager;

@WebServlet(name="OrderManagerServlet", urlPatterns={"/"})
public class OrderManagerServlet
extends HttpServlet {
    @EJB
    private OrderManager orderManager;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("placeOrder") != null) {
            String item = request.getParameter("item");
            try {
                int quantity = Integer.parseInt(request.getParameter("quantity"));
                this.orderManager.addOrder(item, quantity);
                this.displayOrderList(request, response);
            }
            catch (NumberFormatException e) {
                request.setAttribute("info", (Object)"Please enter a valid quantity");
                this.displayHome(request, response);
            }
        } else if (request.getParameter("viewOrder") != null) {
            try {
                request.setAttribute("orders", (Object)this.orderManager.getOrders());
            }
            catch (PersistenceException exception) {
                request.setAttribute("info", (Object)"Please place a order first");
            }
            request.getRequestDispatcher("/WEB-INF/orderList.jsp").forward((ServletRequest)request, (ServletResponse)response);
        } else if (request.getParameter("removeOrder") != null) {
            try {
                int orderId = Integer.parseInt(request.getParameter("orderId"));
                Order orderToBeRemoved = this.orderManager.findOrder(orderId);
                if (orderToBeRemoved != null) {
                    this.orderManager.deleteOrder(orderToBeRemoved);
                    request.setAttribute("info", (Object)("Order with the id " + orderId + " deleted"));
                } else {
                    request.setAttribute("info", (Object)"Order id not found");
                }
            }
            catch (NumberFormatException e) {
                request.setAttribute("info", (Object)"Please enter a valid order id");
            }
            this.displayOrderList(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getRequestDispatcher("/index.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void displayHome(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.getRequestDispatcher("/index.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void displayOrderList(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("orders", (Object)this.orderManager.getOrders());
        request.getRequestDispatcher("/WEB-INF/orderList.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

