/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.common.artifacts.lazyloading;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.appserver.integration.common.artifacts.lazyloading.TenantStatus;
import org.wso2.appserver.integration.common.artifacts.lazyloading.WebAppStatus;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class LazyLoadingInfoUtil {
    private static final Log log = LogFactory.getLog(LazyLoadingInfoUtil.class);
    private static final String CARBON_WEBAPPS_HOLDER_LIST = "carbon.webapps.holderlist";
    private static final String WEBAPPS = "webapps";
    private static final String GHOST_WEB_APP = "GhostWebApp";

    private static ConfigurationContext getServerConfigurationContext() {
        ConfigurationContextService configurationContext = (ConfigurationContextService)PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(ConfigurationContextService.class, null);
        return configurationContext.getServerConfigContext();
    }

    private static Map<String, ConfigurationContext> getTenantConfigServerContexts() {
        return TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)LazyLoadingInfoUtil.getServerConfigurationContext());
    }

    private static ConfigurationContext getTenantConfigurationServerContext(String tenantDomain) {
        return (ConfigurationContext)LazyLoadingInfoUtil.getTenantConfigServerContexts().get(tenantDomain);
    }

    protected static TenantStatus getTenantStatus(String tenantDomain) {
        boolean isTenantContextLoaded = false;
        Map tenantConfigServerContexts = LazyLoadingInfoUtil.getTenantConfigServerContexts();
        if (tenantConfigServerContexts != null) {
            isTenantContextLoaded = tenantConfigServerContexts.containsKey(tenantDomain);
            log.info((Object)("Tenant " + tenantDomain + " loaded :" + isTenantContextLoaded));
        }
        return new TenantStatus(isTenantContextLoaded);
    }

    protected static WebAppStatus getWebAppStatus(String tenantDomain, String webAppName) {
        WebAppStatus webAppStatus = new WebAppStatus();
        ConfigurationContext tenantConfigurationServerContext = LazyLoadingInfoUtil.getTenantConfigurationServerContext((String)tenantDomain);
        if (tenantConfigurationServerContext != null) {
            webAppStatus.setTenantStatus(new TenantStatus(true));
            log.info((Object)("Tenant " + tenantDomain + " configuration context is loaded."));
            WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)((HashMap)tenantConfigurationServerContext.getLocalProperty("carbon.webapps.holderlist")).get("webapps");
            Map startedWebAppMap = webApplicationsHolder.getStartedWebapps();
            if (startedWebAppMap != null) {
                WebApplication webApplication = (WebApplication)startedWebAppMap.get(webAppName);
                if (webApplication != null) {
                    webAppStatus.setWebAppStarted(true);
                    log.info((Object)("Tenant " + tenantDomain + " Web-app: " + webAppName + " is available in configuration context."));
                    boolean isWebAppGhost = Boolean.parseBoolean((String)webApplication.getProperty("GhostWebApp"));
                    log.info((Object)("Tenant " + tenantDomain + " Web-app: " + webAppName + " is in Ghost deployment status :" + isWebAppGhost));
                    webAppStatus.setWebAppGhost(isWebAppGhost);
                } else {
                    log.info((Object)("Given web-app:" + webAppName + " for tenant:" + tenantDomain + " not found in started state"));
                    webAppStatus.setWebAppStarted(false);
                }
            } else {
                log.info((Object)("Tenant " + tenantDomain + " has no started web-apps."));
                webAppStatus.setWebAppStarted(false);
            }
        } else {
            log.info((Object)("Tenant " + tenantDomain + " configuration context is not loaded."));
            webAppStatus.setTenantStatus(new TenantStatus(false));
        }
        return webAppStatus;
    }

    protected static WebAppStatus getSuperTenantWebAppStatus(String webAppName) {
        WebAppStatus webAppStatus = new WebAppStatus();
        webAppStatus.setTenantStatus(new TenantStatus(true));
        ConfigurationContext serverConfigurationContext = LazyLoadingInfoUtil.getServerConfigurationContext();
        WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)((HashMap)serverConfigurationContext.getLocalProperty("carbon.webapps.holderlist")).get("webapps");
        Map startedWebAppMap = webApplicationsHolder.getStartedWebapps();
        if (startedWebAppMap != null) {
            WebApplication webApplication = (WebApplication)startedWebAppMap.get(webAppName);
            if (webApplication != null) {
                webAppStatus.setWebAppStarted(true);
                log.info((Object)("Super Tenant  Web-app: " + webAppName + " is available in configuration context."));
                boolean isWebAppGhost = Boolean.parseBoolean((String)webApplication.getProperty("GhostWebApp"));
                log.info((Object)("Super Tenant Web-app: " + webAppName + " is in Ghost deployment status :" + isWebAppGhost));
                webAppStatus.setWebAppGhost(isWebAppGhost);
            } else {
                log.info((Object)("Given web-app:" + webAppName + " for super tenant  not found in started state"));
            }
        } else {
            log.info((Object)"Super Tenant has no started web-apps.");
        }
        return webAppStatus;
    }
}

