/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.lazy.loading.artifacts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.clients.JaggeryApplicationUploaderClient;
import org.wso2.appserver.integration.common.clients.WebAppAdminClient;
import org.wso2.appserver.integration.common.utils.WebAppDeploymentUtil;
import org.wso2.appserver.integration.lazy.loading.LazyLoadingBaseTest;
import org.wso2.appserver.integration.lazy.loading.util.LazyLoadingTestException;
import org.wso2.appserver.integration.lazy.loading.util.WebAppStatusBean;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.automation.test.utils.http.client.HttpURLConnectionClient;

public class JaggeryApplicationGhostDeploymentTestCase
extends LazyLoadingBaseTest {
    private static final Log log = LogFactory.getLog(JaggeryApplicationGhostDeploymentTestCase.class);
    private static final String JAGGERY_APP_FILE_NAME1 = "hello.jag.zip";
    private static final String JAGGERY_APP_FILE_NAME2 = "bye.jag.zip";
    private static final String JAGGERY_APP_NAME1 = "hello";
    private static final String JAGGERY_APP_NAME2 = "bye";
    private static final String JAGG_APP1_RESPONSE = "Hello";
    private static final String JAGG_APP2_RESPONSE = "Bye";
    private String jagAppFilePath1;
    private String jagAppFilePath2;
    private String tenant1JaggApp1Url;
    private String tenant1JaggApp2Url;
    private volatile List<String> responseDataList = new ArrayList<String>();
    private volatile List<String> responseDetailedInfoList = new ArrayList<String>();

    @Override
    @BeforeClass(alwaysRun=true)
    public void init() throws Exception {
        super.init();
        this.jagAppFilePath1 = this.artifactsLocation + JAGGERY_APP_FILE_NAME1;
        this.jagAppFilePath2 = this.artifactsLocation + JAGGERY_APP_FILE_NAME2;
        this.tenant1JaggApp1Url = this.webAppURL + "/t/" + this.tenantDomain1 + "/jaggeryapps/" + JAGGERY_APP_NAME1 + "/" + JAGGERY_APP_NAME1 + ".jag";
        this.tenant1JaggApp2Url = this.webAppURL + "/t/" + this.tenantDomain1 + "/jaggeryapps/" + JAGGERY_APP_NAME2 + "/" + JAGGERY_APP_NAME2 + ".jag";
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Deploying Jaggery application in Ghost Deployment enableenvironment. Each Jaggery application should fully loaded (non Ghost format) soon after the deployment", alwaysRun=true)
    public void testJaggeryApplicationInGhostDeployment() throws Exception {
        log.info((Object)"deployment of  Jaggery Application started");
        this.init("tenant1", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        JaggeryApplicationUploaderClient jaggeryApplicationUploaderClient = new JaggeryApplicationUploaderClient(this.backendURL, this.sessionCookie);
        jaggeryApplicationUploaderClient.uploadJaggeryFile(JAGGERY_APP_FILE_NAME1, this.jagAppFilePath1);
        Assert.assertTrue((boolean)this.isJaggeryAppDeployed(JAGGERY_APP_NAME1), (String)("Jaggery application  is not deployed correctly. App name: hello Tenant :" + this.tenantDomain1));
        WebAppStatusBean jaggeryAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)jaggeryAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)jaggeryAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Jaggery application: hello is not started after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)jaggeryAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Jaggery application: hello is in ghost mode after deployment in Tenant:" + this.tenantDomain1));
        jaggeryApplicationUploaderClient.uploadJaggeryFile(JAGGERY_APP_FILE_NAME2, this.jagAppFilePath2);
        Assert.assertTrue((boolean)this.isJaggeryAppDeployed(JAGGERY_APP_NAME2), (String)("Jaggery application  is not deployed correctly. App name: bye Tenant :" + this.tenantDomain1));
        WebAppStatusBean jaggeryAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME2);
        Assert.assertTrue((boolean)jaggeryAppStatusTenant1WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)jaggeryAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Jaggery application: bye is not started after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)jaggeryAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Jaggery application: bye is in ghost mode after deployment in Tenant:" + this.tenantDomain1));
        this.init("tenant2", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        jaggeryApplicationUploaderClient = new JaggeryApplicationUploaderClient(this.backendURL, this.sessionCookie);
        jaggeryApplicationUploaderClient.uploadJaggeryFile(JAGGERY_APP_FILE_NAME1, this.jagAppFilePath1);
        Assert.assertTrue((boolean)this.isJaggeryAppDeployed(JAGGERY_APP_NAME1), (String)("Jaggery application  is not deployed correctly. App name: hello Tenant :" + this.tenantDomain2));
        WebAppStatusBean jaggeryAppStatusTenant2WebApp1 = this.getWebAppStatus(this.tenantDomain2, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)jaggeryAppStatusTenant2WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)jaggeryAppStatusTenant2WebApp1.isWebAppStarted(), (String)("Jaggery application: hello is not started after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertFalse((boolean)jaggeryAppStatusTenant2WebApp1.isWebAppGhost(), (String)("Jaggery application: hello is in ghost mode after deployment in Tenant:" + this.tenantDomain2));
        jaggeryApplicationUploaderClient.uploadJaggeryFile(JAGGERY_APP_FILE_NAME2, this.jagAppFilePath2);
        Assert.assertTrue((boolean)this.isJaggeryAppDeployed(JAGGERY_APP_NAME2), (String)("Jaggery application  is not deployed correctly. App name: bye Tenant :" + this.tenantDomain2));
        WebAppStatusBean jaggeryAppStatusTenant2WebApp2 = this.getWebAppStatus(this.tenantDomain2, JAGGERY_APP_NAME2);
        Assert.assertTrue((boolean)jaggeryAppStatusTenant2WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)jaggeryAppStatusTenant2WebApp2.isWebAppStarted(), (String)("Jaggery application: bye is not started after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertFalse((boolean)jaggeryAppStatusTenant2WebApp2.isWebAppGhost(), (String)("Jaggery application: bye is in ghost mode after deployment in Tenant:" + this.tenantDomain2));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Invoke Jaggery application in Ghost Deployment enable environment. First test will restart the server gracefully. After the restart  all tenant context should not be loaded. Then the it invokes the first Jaggery app on first tenant. After the invoke, only that Jaggery app should loaded.", dependsOnMethods={"testJaggeryApplicationInGhostDeployment"})
    public void testInvokeJaggeryAppInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)(" Tenant Name:" + this.tenantDomain1 + "loaded before access."));
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)(" Tenant Name:" + this.tenantDomain2 + "loaded before access."));
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1JaggApp1Url, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)JAGG_APP1_RESPONSE, (String)("Jaggery application invocation fail: " + this.tenant1JaggApp1Url));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Jaggery-app hello is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Jaggery-app: hello is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME2);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Jaggery-app : bye is not started  in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Jaggery-app : bye is loaded before access and after access other web app in same Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)(" Tenant Name:" + this.tenantDomain2 + "loaded before access."));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send a Get request after a Jaggery application is auto unload  and reload in to Ghost form. After access Jaggery application, it should be in fully load form the Ghost form", dependsOnMethods={"testInvokeJaggeryAppInGhostDeployment"})
    public void testJaggeryAppAutoUnLoadAndInvokeInGhostDeployment() throws LazyLoadingTestException {
        HttpResponse httpResponse;
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.tenantDomain1, JAGGERY_APP_NAME1), (String)("Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass. Tenant Name:" + this.tenantDomain1 + " Web_app Name: " + JAGGERY_APP_NAME1));
        try {
            httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1JaggApp1Url, null);
        }
        catch (IOException ioException) {
            String customErrorMessage = "IOException Exception when  send a GET request to" + this.tenant1JaggApp1Url + "\n" + ioException.getMessage();
            log.error((Object)customErrorMessage);
            throw new LazyLoadingTestException(customErrorMessage, ioException);
        }
        Assert.assertEquals((String)httpResponse.getData(), (String)JAGG_APP1_RESPONSE, (String)("Jaggery application invocation fail: " + this.tenant1JaggApp1Url));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Jaggery-app hello is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Jaggery-app: hello is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Test Jaggery application auto unload  and reload in Ghost format. After access Jaggery app, it should be in fully load form  but after configured Jaggery app idle time pass it should get auto unload ne reload in Ghost form.", dependsOnMethods={"testJaggeryAppAutoUnLoadAndInvokeInGhostDeployment"})
    public void testJaggeryAppAutoUnLoadAndReloadInGhostFormInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1JaggApp1Url, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)JAGG_APP1_RESPONSE, (String)("Jaggery application invocation fail: " + this.tenant1JaggApp1Url));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Jaggery-app hello is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Jaggery-app: hello is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.tenantDomain1, JAGGERY_APP_NAME1), (String)("Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass. Tenant Name:" + this.tenantDomain1 + " Web_app Name: " + JAGGERY_APP_NAME1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Test Unload of tenant configuration context  after tenant idle time pass without any action with that tenant", dependsOnMethods={"testJaggeryAppAutoUnLoadAndReloadInGhostFormInGhostDeployment"})
    public void testTenantUnloadInIdleTimeAfterJaggeryAPPUsageInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1JaggApp1Url, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)JAGG_APP1_RESPONSE, (String)("Jaggery application invocation fail: " + this.tenant1JaggApp1Url));
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  not loaded after access. Tenant name: " + this.tenantDomain1));
        Assert.assertTrue((boolean)this.checkTenantAutoUnloading(this.tenantDomain1), (String)("Tenant context is  not unloaded after idle time. Tenant name: " + this.tenantDomain1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send concurrent requests  when tenant context is not loaded.All request should  get expected output", dependsOnMethods={"testTenantUnloadInIdleTimeAfterJaggeryAPPUsageInGhostDeployment"}, enabled=false)
    public void testConcurrentJaggeryAPPInvocationsWhenTenantContextNotLoadedInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        log.info((Object)"Concurrent invocation Start");
        log.info((Object)"Expected Response Data:Hello");
        for (int i = 0; i < 40; ++i) {
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpURLConnectionClient.sendGetRequest((String)JaggeryApplicationGhostDeploymentTestCase.this.tenant1JaggApp1Url, null);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error  when sending a  get request  for :" + JaggeryApplicationGhostDeploymentTestCase.this.tenant1JaggApp1Url), (Throwable)e);
                    }
                    1 var2_3 = this;
                    synchronized (var2_3) {
                        String responseData;
                        String responseDetailedInfo;
                        if (httpResponse != null) {
                            responseDetailedInfo = "Response Data :" + httpResponse.getData() + "\tResponse Code:" + httpResponse.getResponseCode();
                            responseData = httpResponse.getData();
                        } else {
                            responseDetailedInfo = "Response Data : NULL Object return from HttpURLConnectionClient";
                            responseData = "NULL Object return";
                        }
                        JaggeryApplicationGhostDeploymentTestCase.this.responseDataList.add(responseData);
                        log.info((Object)responseDetailedInfo);
                        JaggeryApplicationGhostDeploymentTestCase.this.responseDetailedInfoList.add(responseDetailedInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        log.info((Object)"Concurrent invocation End");
        int correctResponseCount = 0;
        for (String responseData : this.responseDataList) {
            if (!JAGG_APP1_RESPONSE.equals(responseData)) continue;
            ++correctResponseCount;
        }
        StringBuffer allDetailResponseStringBuffer = new StringBuffer();
        allDetailResponseStringBuffer.append("\n");
        for (String responseInfo : this.responseDetailedInfoList) {
            allDetailResponseStringBuffer.append(responseInfo);
            allDetailResponseStringBuffer.append("\n");
        }
        String allDetailResponse = allDetailResponseStringBuffer.toString();
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: hello is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: hello is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertEquals((int)correctResponseCount, (int)40, (String)(allDetailResponse + "All the concurrent requests " + "not get correct response."));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send concurrent requests  when tenant context is loaded. But Jaggery application is in Ghost form. All request should  get expected output", dependsOnMethods={"testConcurrentJaggeryAPPInvocationsWhenTenantContextNotLoadedInGhostDeployment"}, enabled=false)
    public void testConcurrentJaggeryAPPInvocationsWhenTenantContextLoadedInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        this.responseDataList.clear();
        this.responseDetailedInfoList.clear();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        HttpResponse httpResponseApp2 = HttpURLConnectionClient.sendGetRequest((String)this.tenant1JaggApp2Url, null);
        Assert.assertTrue((boolean)httpResponseApp2.getData().contains(JAGG_APP2_RESPONSE), (String)("Invocation of Web-App fail :" + this.tenant1JaggApp2Url));
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  not loaded after access. Tenant name: " + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME2);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: bye is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: bye is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: hello is not started in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: hello is in not ghost mode before invoking in Tenant:" + this.tenantDomain1));
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        log.info((Object)"Concurrent invocation Start");
        log.info((Object)"Expected Response Data:Hello");
        for (int i = 0; i < 40; ++i) {
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpURLConnectionClient.sendGetRequest((String)JaggeryApplicationGhostDeploymentTestCase.this.tenant1JaggApp1Url, null);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error  when sending a  get request  for :" + JaggeryApplicationGhostDeploymentTestCase.this.tenant1JaggApp1Url), (Throwable)e);
                    }
                    2 var2_3 = this;
                    synchronized (var2_3) {
                        String responseData;
                        String responseDetailedInfo;
                        if (httpResponse != null) {
                            responseDetailedInfo = "Response Data :" + httpResponse.getData() + "\tResponse Code:" + httpResponse.getResponseCode();
                            responseData = httpResponse.getData();
                        } else {
                            responseDetailedInfo = "Response Data : NULL Object return from HttpURLConnectionClient";
                            responseData = "NULL Object return";
                        }
                        JaggeryApplicationGhostDeploymentTestCase.this.responseDataList.add(responseData);
                        log.info((Object)responseDetailedInfo);
                        JaggeryApplicationGhostDeploymentTestCase.this.responseDetailedInfoList.add(responseDetailedInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        log.info((Object)"Concurrent invocation End");
        int correctResponseCount = 0;
        for (String responseData : this.responseDataList) {
            if (!JAGG_APP1_RESPONSE.equals(responseData)) continue;
            ++correctResponseCount;
        }
        StringBuilder allDetailResponseStringBuffer = new StringBuilder();
        allDetailResponseStringBuffer.append("\n");
        for (String responseInfo : this.responseDetailedInfoList) {
            allDetailResponseStringBuffer.append(responseInfo);
            allDetailResponseStringBuffer.append("\n");
        }
        String allDetailResponse = allDetailResponseStringBuffer.toString();
        webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, JAGGERY_APP_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: hello is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: hello is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertEquals((int)correctResponseCount, (int)40, (String)(allDetailResponse + "All the concurrent requests" + " not get correct response."));
    }

    @AfterClass(alwaysRun=true)
    public void cleanJaggeryApplication() throws Exception {
        this.init("tenant1", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.deleteWebAppFile(JAGGERY_APP_NAME1, "localhost");
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)JAGGERY_APP_NAME1), (String)("Web Application un-deployment failed : Web app :hello.jag.zip on " + this.tenantDomain1));
        this.webAppAdminClient.deleteWebAppFile(JAGGERY_APP_NAME2, "localhost");
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)JAGGERY_APP_NAME1), (String)("Web Application un-deployment failed: Web app :hello.jag.zip on " + this.tenantDomain1));
        this.init("tenant2", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.deleteWebAppFile(JAGGERY_APP_NAME1, "localhost");
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)JAGGERY_APP_NAME1), (String)("Web Application un-deployment failed : Web app :hello.jag.zip on " + this.tenantDomain2));
        this.webAppAdminClient.deleteWebAppFile(JAGGERY_APP_NAME2, "localhost");
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)JAGGERY_APP_NAME1), (String)("Web Application un-deployment failed: Web app :hello.jag.zip on " + this.tenantDomain2));
    }
}

