/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.lazy.loading.artifacts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.clients.WebAppAdminClient;
import org.wso2.appserver.integration.common.utils.WebAppDeploymentUtil;
import org.wso2.appserver.integration.lazy.loading.LazyLoadingBaseTest;
import org.wso2.appserver.integration.lazy.loading.util.LazyLoadingTestException;
import org.wso2.appserver.integration.lazy.loading.util.WebAppStatusBean;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.automation.test.utils.http.client.HttpURLConnectionClient;

public class SuperTenantGhostDeploymentTestCase
extends LazyLoadingBaseTest {
    private static final Log log = LogFactory.getLog(SuperTenantGhostDeploymentTestCase.class);
    private static final String WEB_APP_FILE_NAME1 = "appServer-valied-deploymant-1.0.0.war";
    private static final String WEB_APP_NAME1 = "appServer-valied-deploymant-1.0.0";
    private static final String WEB_APP_FILE_NAME2 = "helloworld.war";
    private static final String WEB_APP_NAME2 = "helloworld";
    private static final String WEB_APP1_RESPONSE = "<status>success</status>";
    private static final String WEB_APP2_RESPONSE = "<h2>Hello, World.</h2>";
    private String webApp1URL;
    private String webApp2URL;
    private static volatile List<String> responseDataList = new ArrayList<String>();
    private static volatile List<String> responseDetailedInfoList = new ArrayList<String>();
    private static String webApp1Location;
    private static String webApp2Location;

    @Override
    @BeforeClass(alwaysRun=true)
    public void init() throws Exception {
        super.init();
        webApp1Location = this.artifactsLocation + WEB_APP_FILE_NAME1;
        webApp2Location = this.artifactsLocation + WEB_APP_FILE_NAME2;
        this.webApp1URL = this.webAppURL + "/" + WEB_APP_NAME1 + "/";
        this.webApp2URL = this.webAppURL + "/" + WEB_APP_NAME2 + "/hi.jsp";
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Deploying web application in Ghost Deployment enable environment. Each Web application should fully loaded (non Ghost format) soon after the deployment", alwaysRun=true)
    public void testDeployWebApplicationInGhostDeploymentOnSuperTenant() throws Exception {
        log.info((Object)"deployment of  web application started");
        this.init("superTenant", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.uploadWarFile(webApp1Location);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME1), (String)("Web Application deployment failed: appServer-valied-deploymant-1.0.0on " + this.tenantDomain1));
        WebAppStatusBean webAppStatusWebApp1 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusWebApp1.isWebAppStarted(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is not started after deployment in  Supper Tenant");
        Assert.assertFalse((boolean)webAppStatusWebApp1.isWebAppGhost(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after deployment in Supper Tenant");
        this.webAppAdminClient.uploadWarFile(webApp2Location);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME2), (String)("Web Application deployment failed: helloworldon " + this.tenantDomain1));
        WebAppStatusBean webAppStatusWebApp2 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusWebApp2.isWebAppStarted(), (String)"Web-App: helloworld.war is not started after deployment in  Supper Tenant");
        Assert.assertFalse((boolean)webAppStatusWebApp2.isWebAppGhost(), (String)"Web-App: helloworld.war is in ghost mode after deployment in Supper Tenant");
        log.info((Object)"deployment of web application finished");
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Invoke web application in Ghost Deployment enable environment.First test will restart the server gracefully.After the restart  all web apps should be in ghost format.Then,  it invokes the first web app on first tenant. After the invoke, only that web app should loaded fully and all other web apps should be in Ghost format.", dependsOnMethods={"testDeployWebApplicationInGhostDeploymentOnSuperTenant"})
    public void testInvokeWebAppInGhostDeploymentOnSuperTenant() throws Exception {
        this.serverManager.restartGracefully();
        WebAppStatusBean webAppStatusWebApp1 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusWebApp1.isWebAppStarted(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is not started in  Supper Tenant");
        Assert.assertTrue((boolean)webAppStatusWebApp1.isWebAppGhost(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is not in ghost mode before invoking in Supper Tenant");
        WebAppStatusBean webAppStatusWebApp2 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusWebApp2.isWebAppStarted(), (String)"Web-App: helloworld.war is not started in  SupperTenant");
        Assert.assertTrue((boolean)webAppStatusWebApp2.isWebAppGhost(), (String)"Web-App: helloworld.war is not in ghost mode before invoking in Supper Tenant");
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.webApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)("Web app invocation fail. web app URL:" + this.webApp1URL));
        webAppStatusWebApp1 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusWebApp1.isWebAppStarted(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is not started in  Supper Tenant");
        Assert.assertFalse((boolean)webAppStatusWebApp1.isWebAppGhost(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is  in ghost mode after invoking in Supper Tenant");
        webAppStatusWebApp2 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusWebApp2.isWebAppStarted(), (String)"Web-App: helloworld.war is not started in  SupperTenant");
        Assert.assertTrue((boolean)webAppStatusWebApp2.isWebAppGhost(), (String)"Web-App: helloworld.war is not in ghost mode before invoking the other web-app of in Supper Tenant");
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send a Get request after a web app is auto unload  and reload in to Ghost form. After access web app, it should be in fully load form  the Ghost form", dependsOnMethods={"testInvokeWebAppInGhostDeploymentOnSuperTenant"})
    public void testWebAppAutoUnLoadAndInvokeInGhostDeploymentOnSuperTenant() throws LazyLoadingTestException {
        HttpResponse httpResponse;
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.superTenantDomain, WEB_APP_FILE_NAME1), (String)"Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass in super tenant Web_app Name: appServer-valied-deploymant-1.0.0.war");
        try {
            httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.webApp1URL, null);
        }
        catch (IOException ioException) {
            String customErrorMessage = "IOException Exception when  send a GET request to" + this.webApp1URL + "\n" + ioException.getMessage();
            log.error((Object)customErrorMessage);
            throw new LazyLoadingTestException(customErrorMessage, ioException);
        }
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)("Web app invocation fail. Web App in Ghost mode:" + this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1).isWebAppGhost() + "Web App Started:" + this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1).isWebAppStarted()));
        WebAppStatusBean webAppStatusWebApp1 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusWebApp1.isWebAppStarted(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is not started in  Supper Tenant");
        Assert.assertFalse((boolean)webAppStatusWebApp1.isWebAppGhost(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is  in ghost mode after invoking in Supper Tenant");
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Test web application auto unload  and reload in Ghost format. After access web app, it should be in fully load form  but after configured web app idle time pass it should get auto unload ne reload in Ghost form.", dependsOnMethods={"testWebAppAutoUnLoadAndInvokeInGhostDeploymentOnSuperTenant"})
    public void testWebAppAutoUnLoadAndReloadInGhostFormInGhostDeploymentOnSuperTenant() throws Exception {
        this.serverManager.restartGracefully();
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.webApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)"Web app invocation fail");
        WebAppStatusBean webAppStatusWebApp1 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusWebApp1.isWebAppStarted(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is not started in  Supper Tenant");
        Assert.assertFalse((boolean)webAppStatusWebApp1.isWebAppGhost(), (String)"Web-App: appServer-valied-deploymant-1.0.0.war is  in ghost mode after invoking in Supper Tenant");
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.superTenantDomain, WEB_APP_FILE_NAME1), (String)"Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass in super tenant Web_app Name: appServer-valied-deploymant-1.0.0.war");
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send concurrent requests  when Web-App is in Ghost form. All request should  get expected output", dependsOnMethods={"testWebAppAutoUnLoadAndReloadInGhostFormInGhostDeploymentOnSuperTenant"}, enabled=false)
    public void testConcurrentWebAPPInvocationsWhenWebAppIsInGhostFormInGhostDeploymentOnSuperTenant() throws Exception {
        this.serverManager.restartGracefully();
        HttpResponse httpResponseApp2 = HttpURLConnectionClient.sendGetRequest((String)this.webApp2URL, null);
        Assert.assertTrue((boolean)httpResponseApp2.getData().contains(WEB_APP2_RESPONSE), (String)("Invocation of Web-App fail :" + this.webApp2URL));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: helloworld.war is not started in Tenant:" + this.superTenantDomain));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: helloworld.war is in ghost mode after invoking in Tenant:" + this.superTenantDomain));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.superTenantDomain));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in not ghost mode before invoking in Tenant:" + this.superTenantDomain));
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        log.info((Object)"Concurrent invocation Start");
        log.info((Object)"Expected Response Data:<status>success</status>");
        int i = 0;
        while (i < 40) {
            final int requestId = i++;
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpURLConnectionClient.sendGetRequest((String)SuperTenantGhostDeploymentTestCase.this.webApp1URL, null);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error  when sending a  get request  for :" + SuperTenantGhostDeploymentTestCase.this.webApp1URL), (Throwable)e);
                    }
                    1 var2_3 = this;
                    synchronized (var2_3) {
                        String responseData;
                        String responseDetailedInfo;
                        if (httpResponse != null) {
                            responseDetailedInfo = "Request ID " + requestId + " Response Data :" + httpResponse.getData() + "\tResponse Code:" + httpResponse.getResponseCode();
                            responseData = httpResponse.getData();
                        } else {
                            responseDetailedInfo = "Request ID " + requestId + " Response Data : NULL Object return from" + " HttpURLConnectionClient";
                            responseData = "NULL Object return";
                        }
                        responseDataList.add(responseData);
                        log.info((Object)responseDetailedInfo);
                        responseDetailedInfoList.add(responseDetailedInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        log.info((Object)"Concurrent invocation End");
        int correctResponseCount = 0;
        for (String responseData : responseDataList) {
            if (!WEB_APP1_RESPONSE.equals(responseData)) continue;
            ++correctResponseCount;
        }
        StringBuilder allDetailResponseStringBuffer = new StringBuilder();
        allDetailResponseStringBuffer.append("\n");
        for (String responseInfo : responseDetailedInfoList) {
            allDetailResponseStringBuffer.append(responseInfo);
            allDetailResponseStringBuffer.append("\n");
        }
        String allDetailResponse = allDetailResponseStringBuffer.toString();
        webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.superTenantDomain, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.superTenantDomain));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.superTenantDomain));
        Assert.assertEquals((int)correctResponseCount, (int)40, (String)(allDetailResponse + "All the concurrent requests not get correct response."));
    }

    @AfterClass(alwaysRun=true)
    public void cleanWebApplications() throws Exception {
        this.init("superTenant", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.deleteWebAppFile(WEB_APP_FILE_NAME1, this.hostURL);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME1), (String)"Web Application un-deployment failed : Web app :appServer-valied-deploymant-1.0.0 on super tenant");
        this.webAppAdminClient.deleteWebAppFile(WEB_APP_FILE_NAME2, this.hostURL);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME2), (String)"Web Application un-deployment failed: Web app :helloworld on super tenant");
    }
}

