/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.lazy.loading.tenants;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.lazy.loading.LazyLoadingBaseTest;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;

public class TenantEagerLoadingTestCase
extends LazyLoadingBaseTest {
    private static final Log log = LogFactory.getLog(TenantEagerLoadingTestCase.class);

    @Override
    @BeforeClass(alwaysRun=true)
    public void init() throws Exception {
        this.ARTIFACTS_LOCATION = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AS" + File.separator + "eager" + File.separator;
        super.init();
    }

    @Test(groups={"wso2.as.eager.loading"}, description="Test for loading all tenants with server startup", alwaysRun=true)
    public void testLoadAllTenant() throws Exception {
        String carbonArtifactLocation = this.ARTIFACTS_LOCATION + "carbon-01.xml";
        this.applyCarbonXMLConfigChange(carbonArtifactLocation);
        Assert.assertEquals((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (boolean)true, (String)("Tenant " + this.tenantDomain1 + " is not loaded"));
        Assert.assertEquals((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (boolean)true, (String)("Tenant " + this.tenantDomain2 + " is not loaded"));
    }

    @Test(groups={"wso2.as.eager.loading"}, description="Test for loading all tenants, but not tenant1.com with server startup", alwaysRun=true, dependsOnMethods={"testLoadAllTenant"})
    public void testNotLoadSpecificTenant() throws Exception {
        String carbonArtifactLocation = this.ARTIFACTS_LOCATION + "carbon-02.xml";
        this.applyCarbonXMLConfigChange(carbonArtifactLocation);
        Assert.assertEquals((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (boolean)false, (String)("Tenant " + this.tenantDomain1 + " is loaded, but expected not to be loaded"));
        Assert.assertEquals((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (boolean)true, (String)("Tenant " + this.tenantDomain2 + " is not loaded"));
    }

    @Test(groups={"wso2.as.eager.loading"}, description="Test for load tenant1.com only at server startup", alwaysRun=true, dependsOnMethods={"testNotLoadSpecificTenant"})
    public void testLoadSpecificTenant() throws Exception {
        String carbonArtifactLocation = this.ARTIFACTS_LOCATION + "carbon-03.xml";
        this.applyCarbonXMLConfigChange(carbonArtifactLocation);
        Assert.assertEquals((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (boolean)true, (String)("Tenant " + this.tenantDomain1 + " is not loaded"));
        Assert.assertEquals((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (boolean)false, (String)("Tenant " + this.tenantDomain2 + " is loaded, but expected not to be loaded"));
    }

    private void applyCarbonXMLConfigChange(String carbonXMLLocation) throws Exception {
        File sourceFile = new File(carbonXMLLocation);
        File targetFile = new File(CARBON_REPOSITORY_LOCATION);
        this.serverManager.applyConfigurationWithoutRestart(sourceFile, targetFile, true);
        log.info((Object)("carbon.xml replaced with :" + carbonXMLLocation));
        this.serverManager.restartGracefully();
        log.info((Object)"Server Restarted after applying carbon.xml and tenant information utility web application");
    }
}

