/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.lazy.loading.artifacts;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.utils.WebAppDeploymentUtil;
import org.wso2.appserver.integration.lazy.loading.LazyLoadingBaseTest;
import org.wso2.appserver.integration.lazy.loading.util.LazyLoadingTestException;
import org.wso2.appserver.integration.lazy.loading.util.WebAppStatusBean;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.automation.test.utils.http.client.HttpURLConnectionClient;
import org.wso2.carbon.integration.common.admin.client.ApplicationAdminClient;
import org.wso2.carbon.integration.common.admin.client.CarbonAppUploaderClient;

public class CarbonAppGhostDeploymentTestCase
extends LazyLoadingBaseTest {
    private static final Log log = LogFactory.getLog(CarbonAppGhostDeploymentTestCase.class);
    private static final String CARBON_APP_NAME1 = "WarCApp_1.0.0";
    private static final String CARBON_APP_FILE1 = "WarCApp_1.0.0.car";
    private static final String CARBON_APP1_WEB_APP_NAME = "appServer-valid-deploymant-1.0.0";
    private static final String CARBON_APP1_WEB_APP_FILE = "appServer-valid-deploymant-1.0.0.war";
    private static final String CARBON_APP_NAME2 = "webappunpackCar_1.0.0";
    private static final String CARBON_APP_FILE2 = "unpackwebappCar_1.0.0.car";
    private static final String CARBON_APP2_WEB_APP_NAME = "myWebapp-1.0.0";
    private static final String CARBON_APP2_WEB_APP_FILE = "myWebapp-1.0.0.war";
    private static final String WEB_APP1_RESPONSE = "<status>success</status>";
    private static final String WEB_APP2_RESPONSE = "<h1>Holla!!!</h1>";
    private String tenant1WebApp1URL;
    private String tenant1WebApp2URL;
    private static volatile List<String> responseDataList = new ArrayList<String>();
    private static volatile List<String> responseDetailedInfoList = new ArrayList<String>();
    private DataHandler carbonApp1URLDataHandler;
    private DataHandler carbonApp2URLDataHandler;

    @Override
    @BeforeClass(alwaysRun=true)
    public void init() throws Exception {
        super.init();
        this.tenant1WebApp1URL = this.webAppURL + "/t/" + this.tenantDomain1 + "/webapps/" + CARBON_APP1_WEB_APP_NAME + "/";
        URL carbonApp1FileURL = new URL("file://" + this.artifactsLocation + CARBON_APP_FILE1);
        this.carbonApp1URLDataHandler = new DataHandler(carbonApp1FileURL);
        this.tenant1WebApp2URL = this.webAppURL + "/t/" + this.tenantDomain1 + "/webapps/" + CARBON_APP2_WEB_APP_NAME + "/";
        URL carbonApp2FileURL = new URL("file://" + this.artifactsLocation + CARBON_APP_FILE2);
        this.carbonApp2URLDataHandler = new DataHandler(carbonApp2FileURL);
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Upload car file and verify in ghost deployment enable environment. After the the deployment all the web applications of  the carbon application should be deployed correctly and  they should be loaded fully(Not in ghost form) ", alwaysRun=true)
    public void carApplicationUploadInGhostDeployment() throws Exception {
        log.info((Object)"Carbon application deployment start");
        this.init("tenant1", "admin");
        CarbonAppUploaderClient carbonAppUploaderClient = new CarbonAppUploaderClient(this.backendURL, this.sessionCookie);
        carbonAppUploaderClient.uploadCarbonAppArtifact(CARBON_APP_FILE1, this.carbonApp1URLDataHandler);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)CARBON_APP1_WEB_APP_NAME), (String)("Web Application deployment failed: appServer-valid-deploymant-1.0.0on " + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in ghost mode after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)this.isCarbonAppListed(CARBON_APP_NAME1), (String)"Carbon Application is not listed :WarCApp_1.0.0");
        carbonAppUploaderClient.uploadCarbonAppArtifact(CARBON_APP_FILE2, this.carbonApp2URLDataHandler);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)CARBON_APP2_WEB_APP_NAME), (String)("Web Application deployment failed: myWebapp-1.0.0on " + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP2_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: myWebapp-1.0.0.war is not started after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: myWebapp-1.0.0.war is in ghost mode after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)this.isCarbonAppListed(CARBON_APP_NAME2), (String)"Carbon Application is not listed :webappunpackCar_1.0.0");
        this.init("tenant2", "admin");
        carbonAppUploaderClient = new CarbonAppUploaderClient(this.backendURL, this.sessionCookie);
        carbonAppUploaderClient.uploadCarbonAppArtifact(CARBON_APP_FILE1, this.carbonApp1URLDataHandler);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)CARBON_APP1_WEB_APP_NAME), (String)("Web Application deployment failed: appServer-valid-deploymant-1.0.0on " + this.tenantDomain2));
        WebAppStatusBean webAppStatusTenant2WebApp1 = this.getWebAppStatus(this.tenantDomain2, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertEquals((boolean)webAppStatusTenant2WebApp1.isWebAppGhost(), (boolean)false, (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in ghost mode after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)this.isCarbonAppListed(CARBON_APP_NAME1), (String)"Carbon Application is not listed :WarCApp_1.0.0");
        carbonAppUploaderClient.uploadCarbonAppArtifact(CARBON_APP_FILE2, this.carbonApp2URLDataHandler);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)CARBON_APP2_WEB_APP_NAME), (String)("Web Application deployment failed: myWebapp-1.0.0on " + this.tenantDomain2));
        WebAppStatusBean webAppStatusTenant2WebApp2 = this.getWebAppStatus(this.tenantDomain2, CARBON_APP2_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp2.isWebAppStarted(), (String)("Web-App: myWebapp-1.0.0.war is not started after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertFalse((boolean)webAppStatusTenant2WebApp2.isWebAppGhost(), (String)("Web-App: myWebapp-1.0.0.war is in ghost mode after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)this.isCarbonAppListed(CARBON_APP_NAME2), (String)"Carbon Application is not listed :webappunpackCar_1.0.0");
        log.info((Object)"Carbon application deployment end");
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="  Invoke web application that is deployed as Carbon application in Ghost Deployment enable environment.First test will restart the server gracefully.After the restart  all   tenant context not be loaded.Then,  it invokes the first web app on first tenant. After the invoke, only that web app should loaded fully.", dependsOnMethods={"carApplicationUploadInGhostDeployment"})
    public void testInvokeWebAppInCarbonAppInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)(" Tenant Name:" + this.tenantDomain1 + "loaded before access."));
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)(" Tenant Name:" + this.tenantDomain2 + "loaded before access."));
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)("Web app invocation fail. web app URL:" + this.tenant1WebApp1URL));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP2_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: myWebapp-1.0.0.war is not started  in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: myWebapp-1.0.0.war is loaded before access it and after access other web app in same Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)(" Tenant Name:" + this.tenantDomain2 + "loaded before access."));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send a Get request after a Carbon application is auto unload and reload in to Ghost form. After access Carbon application, it should be in fully load form  the Ghost form", dependsOnMethods={"testInvokeWebAppInCarbonAppInGhostDeployment"})
    public void testWebAppInCarbonAppAutoUnLoadAndInvokeInGhostDeployment() throws LazyLoadingTestException {
        HttpResponse httpResponse;
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE), (String)("Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass. Tenant Name:" + this.tenantDomain1 + " Web_app Name: " + CARBON_APP1_WEB_APP_FILE));
        try {
            httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        }
        catch (IOException ioException) {
            String customErrorMessage = "IOException Exception when  send a GET request to" + this.tenant1WebApp1URL + "\n" + ioException.getMessage();
            log.error((Object)customErrorMessage);
            throw new LazyLoadingTestException(customErrorMessage, ioException);
        }
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)"Web app invocation fail");
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Test web application that is deployed as Carbon application, auto unload  and reload in Ghost format. After access web app, it should be in fully load form  but after configured web app idle time pass it should get auto unload ne reload in Ghost form.", dependsOnMethods={"testWebAppInCarbonAppAutoUnLoadAndInvokeInGhostDeployment"})
    public void testWebAppInCarbonAppAutoUnLoadAndReloadInGhostFormInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)"Web app invocation fail");
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE), (String)("Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass. Tenant Name:" + this.tenantDomain1 + " Web_app Name: " + CARBON_APP1_WEB_APP_FILE));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Test Unload of tenant configuration context  after tenant idle time pass without any action with that tenant", dependsOnMethods={"testWebAppInCarbonAppAutoUnLoadAndReloadInGhostFormInGhostDeployment"})
    public void testTenantUnloadInIdleTimeAfterWebAPPInCarbonAppUsageInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)"Web app invocation fail");
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  not loaded after access. Tenant name: " + this.tenantDomain1));
        Assert.assertTrue((boolean)this.checkTenantAutoUnloading(this.tenantDomain1), (String)("Tenant context is  not unloaded after idle time. Tenant name: " + this.tenantDomain1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send concurrent requests  when tenant context is not loaded.All request should  get expected output", dependsOnMethods={"testTenantUnloadInIdleTimeAfterWebAPPInCarbonAppUsageInGhostDeployment"}, enabled=false)
    public void testConcurrentWebAPPInCarbonAppInvocationsWhenTenantContextNotLoadedInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        log.info((Object)"Concurrent invocation Start");
        log.info((Object)"Expected Response Data:<status>success</status>");
        for (int i = 0; i < 40; ++i) {
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpURLConnectionClient.sendGetRequest((String)CarbonAppGhostDeploymentTestCase.this.tenant1WebApp1URL, null);
                    }
                    catch (IOException ioException) {
                        log.error((Object)("Error  when sending a  get request  for :" + CarbonAppGhostDeploymentTestCase.this.tenant1WebApp1URL), (Throwable)ioException);
                    }
                    1 var2_3 = this;
                    synchronized (var2_3) {
                        String responseData;
                        String responseDetailedInfo;
                        if (httpResponse != null) {
                            responseDetailedInfo = "Response Data :" + httpResponse.getData() + "\tResponse Code:" + httpResponse.getResponseCode();
                            responseData = httpResponse.getData();
                        } else {
                            responseDetailedInfo = "Response Data : NULL Object return from HttpURLConnectionClient";
                            responseData = "NULL Object return ";
                        }
                        responseDataList.add(responseData);
                        log.info((Object)responseDetailedInfo);
                        responseDetailedInfoList.add(responseDetailedInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        log.info((Object)"Concurrent invocation End");
        int correctResponseCount = 0;
        for (String responseData : responseDataList) {
            if (!WEB_APP1_RESPONSE.equals(responseData)) continue;
            ++correctResponseCount;
        }
        StringBuilder allDetailResponseStringBuffer = new StringBuilder();
        allDetailResponseStringBuffer.append("\n");
        for (String responseInfo : responseDetailedInfoList) {
            allDetailResponseStringBuffer.append(responseInfo);
            allDetailResponseStringBuffer.append("\n");
        }
        String allDetailResponse = allDetailResponseStringBuffer.toString();
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertEquals((int)correctResponseCount, (int)40, (String)(allDetailResponse + "All the concurrent requests " + "not get correct response."));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send concurrent requests  when tenant context is loaded. But Web-App  that is deployed as Carbon application is in Ghost form. All request should  get expected output", dependsOnMethods={"testConcurrentWebAPPInCarbonAppInvocationsWhenTenantContextNotLoadedInGhostDeployment"}, enabled=false)
    public void testConcurrentWebAPPInCarbonAppInvocationsWhenTenantContextLoadedInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        responseDataList.clear();
        responseDetailedInfoList.clear();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        HttpResponse httpResponseApp2 = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp2URL, null);
        Assert.assertTrue((boolean)httpResponseApp2.getData().contains(WEB_APP2_RESPONSE), (String)("Invocation of Web-App fail :" + this.tenant1WebApp2URL));
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  not loaded after access. Tenant name: " + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP2_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: myWebapp-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: myWebapp-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in not ghost mode before invoking in Tenant:" + this.tenantDomain1));
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        log.info((Object)"Concurrent invocation Start");
        log.info((Object)"Expected Response Data:<status>success</status>");
        for (int i = 0; i < 40; ++i) {
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpURLConnectionClient.sendGetRequest((String)CarbonAppGhostDeploymentTestCase.this.tenant1WebApp1URL, null);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error  when sending a  get request  for :" + CarbonAppGhostDeploymentTestCase.this.tenant1WebApp1URL), (Throwable)e);
                    }
                    2 var2_3 = this;
                    synchronized (var2_3) {
                        String responseData;
                        String responseDetailedInfo;
                        if (httpResponse != null) {
                            responseDetailedInfo = "Response Data :" + httpResponse.getData() + "\tResponse Code:" + httpResponse.getResponseCode();
                            responseData = httpResponse.getData();
                        } else {
                            responseDetailedInfo = "Response Data : NULL Object return from HttpURLConnectionClient";
                            responseData = "NULL Object return";
                        }
                        responseDataList.add(responseData);
                        log.info((Object)responseDetailedInfo);
                        responseDetailedInfoList.add(responseDetailedInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        log.info((Object)"Concurrent invocation End");
        int correctResponseCount = 0;
        for (String responseData : responseDataList) {
            if (!WEB_APP1_RESPONSE.equals(responseData)) continue;
            ++correctResponseCount;
        }
        StringBuilder allDetailResponseStringBuffer = new StringBuilder();
        allDetailResponseStringBuffer.append("\n");
        for (String responseInfo : responseDetailedInfoList) {
            allDetailResponseStringBuffer.append(responseInfo);
            allDetailResponseStringBuffer.append("\n");
        }
        String allDetailResponse = allDetailResponseStringBuffer.toString();
        webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, CARBON_APP1_WEB_APP_FILE);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valid-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertEquals((int)correctResponseCount, (int)40, (String)(allDetailResponse + "All the concurrent requests" + " not get correct response."));
    }

    @AfterClass(alwaysRun=true)
    public void cleanCarbonApplications() throws Exception {
        this.init("tenant1", "admin");
        ApplicationAdminClient appAdminClient = new ApplicationAdminClient(this.backendURL, this.sessionCookie);
        appAdminClient.deleteApplication(CARBON_APP_NAME1);
        log.info((Object)("Carbon application deleted : WarCApp_1.0.0on " + this.tenantDomain1));
        appAdminClient.deleteApplication(CARBON_APP_NAME2);
        log.info((Object)("Carbon application deleted : webappunpackCar_1.0.0on " + this.tenantDomain1));
        this.init("tenant2", "admin");
        appAdminClient = new ApplicationAdminClient(this.backendURL, this.sessionCookie);
        appAdminClient.deleteApplication(CARBON_APP_NAME1);
        log.info((Object)("Carbon application deleted : WarCApp_1.0.0on " + this.tenantDomain2));
        appAdminClient.deleteApplication(CARBON_APP_NAME2);
        log.info((Object)("Carbon application deleted : webappunpackCar_1.0.0on " + this.tenantDomain2));
    }
}

